/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.db.internal.sql.join.IJoinAccessor;

public class DatabaseJoinAccessor
implements IJoinAccessor {
    private static final String SELECT_QUERY_IDS = "select DISTINCT query_id from %s";
    private static final String INSERT_INTO_JOIN_ID4 = "INSERT INTO osee_join_id4 (query_id, id1, id2, id3, id4) VALUES (?, ?, ?, ?, ?)";
    private static final String INSERT_INTO_JOIN_TRANSACTION = "INSERT INTO osee_join_transaction (query_id, gamma_id, transaction_id, branch_id) VALUES (?, ?, ?, ?)";
    private static final String INSERT_INTO_TAG_GAMMA_QUEUE = "INSERT INTO osee_tag_gamma_queue (query_id, gamma_id) VALUES (?, ?)";
    private static final String INSERT_INTO_JOIN_EXPORT_IMPORT = "INSERT INTO osee_join_export_import (query_id, id1, id2) VALUES (?, ?, ?)";
    private static final String INSERT_INTO_JOIN_ID = "INSERT INTO osee_join_id (query_id, id) VALUES (?, ?)";
    private static final String INSERT_INTO_JOIN_CHAR_ID = "INSERT INTO osee_join_char_id (query_id, id) VALUES (?, ?)";
    private static final String DELETE_FROM_JOIN_ID = "DELETE FROM osee_join_id WHERE query_id = ?";
    private static final String DELETE_FROM_JOIN_TRANSACTION = "DELETE FROM osee_join_transaction WHERE query_id = ?";
    private static final String DELETE_FROM_TAG_GAMMA_QUEUE = "DELETE FROM osee_tag_gamma_queue WHERE query_id = ?";
    private static final String DELETE_FROM_JOIN_EXPORT_IMPORT = "DELETE FROM osee_join_export_import WHERE query_id =?";
    private static final String DELETE_FROM_JOIN_CHAR_ID = "DELETE FROM osee_join_char_id WHERE query_id =?";
    private static final String DELETE_FROM_JOIN_ID4 = "DELETE FROM osee_join_id4 WHERE query_id = ?";
    private static final String INSERT_INTO_JOIN_CLEANUP = "INSERT INTO osee_join_cleanup (query_id, table_name, issued_at, expires_in) VALUES (?,?,?,?)";
    private static final String DELETE_FROM_JOIN_CLEANUP = "DELETE FROM osee_join_cleanup WHERE query_id =?";
    private final JdbcClient jdbcClient;

    public DatabaseJoinAccessor(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    @Override
    public int delete(JdbcConnection connection, JoinItem joinItem, int queryId) throws OseeCoreException {
        int updated = 0;
        if (queryId != -1) {
            updated = this.jdbcClient.runPreparedUpdate(connection, joinItem.getDeleteSql(), new Object[]{queryId});
            this.jdbcClient.runPreparedUpdate(connection, DELETE_FROM_JOIN_CLEANUP, new Object[]{queryId});
        }
        return updated;
    }

    @Override
    public void store(JdbcConnection connection, JoinItem joinItem, int queryId, List<Object[]> dataList, Long issuedAt, Long expiresIn) throws OseeCoreException {
        this.jdbcClient.runPreparedUpdate(connection, INSERT_INTO_JOIN_CLEANUP, new Object[]{queryId, joinItem.getJoinTableName(), issuedAt, expiresIn});
        this.jdbcClient.runBatchUpdate(connection, joinItem.getInsertSql(), dataList);
    }

    @Override
    public Collection<Integer> getAllQueryIds(JdbcConnection connection, JoinItem joinItem) throws OseeCoreException {
        ArrayList<Integer> queryIds = new ArrayList<Integer>();
        try (JdbcStatement chStmt = this.jdbcClient.getStatement(connection);){
            String query = String.format(SELECT_QUERY_IDS, joinItem.getJoinTableName());
            chStmt.runPreparedQuery(query, new Object[0]);
            while (chStmt.next()) {
                queryIds.add(chStmt.getInt("query_id"));
            }
        }
        return queryIds;
    }

    public static enum JoinItem {
        TRANSACTION("osee_join_transaction", "INSERT INTO osee_join_transaction (query_id, gamma_id, transaction_id, branch_id) VALUES (?, ?, ?, ?)", "DELETE FROM osee_join_transaction WHERE query_id = ?"),
        ID4("osee_join_id4", "INSERT INTO osee_join_id4 (query_id, id1, id2, id3, id4) VALUES (?, ?, ?, ?, ?)", "DELETE FROM osee_join_id4 WHERE query_id = ?"),
        TAG_GAMMA_QUEUE("osee_tag_gamma_queue", "INSERT INTO osee_tag_gamma_queue (query_id, gamma_id) VALUES (?, ?)", "DELETE FROM osee_tag_gamma_queue WHERE query_id = ?"),
        EXPORT_IMPORT("osee_join_export_import", "INSERT INTO osee_join_export_import (query_id, id1, id2) VALUES (?, ?, ?)", "DELETE FROM osee_join_export_import WHERE query_id =?"),
        ID("osee_join_id", "INSERT INTO osee_join_id (query_id, id) VALUES (?, ?)", "DELETE FROM osee_join_id WHERE query_id = ?"),
        CHAR_ID("osee_join_char_id", "INSERT INTO osee_join_char_id (query_id, id) VALUES (?, ?)", "DELETE FROM osee_join_char_id WHERE query_id =?");

        private final String tableName;
        private final String deleteSql;
        private final String insertSql;

        private JoinItem(String tableName, String insertSql, String deleteSql) {
            this.tableName = tableName;
            this.deleteSql = deleteSql;
            this.insertSql = insertSql;
        }

        public String getDeleteSql() {
            return this.deleteSql;
        }

        public String getInsertSql() {
            return this.insertSql;
        }

        public String getJoinTableName() {
            return this.tableName;
        }
    }
}

