/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.orcs.db.internal.sql.join.DatabaseJoinAccessor;
import org.eclipse.osee.orcs.db.internal.sql.join.IJoinAccessor;

public abstract class AbstractJoinQuery {
    private final IJoinAccessor joinAccessor;
    private final DatabaseJoinAccessor.JoinItem joinItem;
    private final Long expiresIn;
    private final int queryId;
    protected final Set<IJoinRow> entries = new HashSet<IJoinRow>();
    private boolean wasStored;
    private int storedSize;

    protected AbstractJoinQuery(IJoinAccessor joinAccessor, DatabaseJoinAccessor.JoinItem joinItem, Long expiresIn, int queryId) {
        this.joinAccessor = joinAccessor;
        this.joinItem = joinItem;
        this.expiresIn = expiresIn;
        this.queryId = queryId;
        this.storedSize = -1;
        this.wasStored = false;
    }

    public boolean isEmpty() {
        return !this.wasStored ? this.entries.isEmpty() : this.storedSize > 0;
    }

    public int size() {
        return !this.wasStored ? this.entries.size() : this.storedSize;
    }

    public int getQueryId() {
        return this.queryId;
    }

    public String getJoinTableName() {
        return this.joinItem.getJoinTableName();
    }

    public boolean wasStored() {
        return this.wasStored;
    }

    public void store(JdbcConnection connection) throws OseeCoreException {
        ArrayList<Object[]> data;
        if (!this.wasStored) {
            data = new ArrayList<Object[]>();
            for (IJoinRow joinArray : this.entries) {
                data.add(joinArray.toArray());
            }
        } else {
            throw new OseeCoreException("Cannot store query id twice", new Object[0]);
        }
        this.joinAccessor.store(connection, this.joinItem, this.getQueryId(), data, this.getIssuedAt(), this.getExpiresIn());
        this.storedSize = this.entries.size();
        this.wasStored = true;
        this.entries.clear();
    }

    private Long getIssuedAt() {
        return System.currentTimeMillis() / 1000L;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public int delete(JdbcConnection connection) throws OseeCoreException {
        return this.joinAccessor.delete(connection, this.joinItem, this.getQueryId());
    }

    public void store() throws OseeCoreException {
        this.store(null);
    }

    public int delete() throws OseeCoreException {
        return this.delete(null);
    }

    public Collection<Integer> getAllQueryIds(JdbcConnection connection) throws OseeCoreException {
        return this.joinAccessor.getAllQueryIds(connection, this.joinItem);
    }

    public Collection<Integer> getAllQueryIds() throws OseeCoreException {
        return this.joinAccessor.getAllQueryIds(null, this.joinItem);
    }

    public String toString() {
        return String.format("id: [%s] entrySize: [%d]", this.getQueryId(), this.size());
    }

    protected static interface IJoinRow {
        public Object[] toArray();

        public String toString();
    }
}

