/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql;

import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.db.internal.sql.AliasEntry;
import org.eclipse.osee.orcs.db.internal.sql.WithClause;

public final class SqlUtil {
    private SqlUtil() {
    }

    public static AliasEntry newAlias(final String name, final String prefix) {
        return new AliasEntry(){

            @Override
            public String getPrefix() {
                return prefix;
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    public static WithClause newSimpleWithClause(String name, String body) {
        return SqlUtil.newWithClause(false, name, "", body);
    }

    public static WithClause newRecursiveWithClause(String name, String parameters, String body) {
        return SqlUtil.newWithClause(true, name, parameters, body);
    }

    public static WithClause newWithClause(final boolean isRecursive, final String name, final String parameters, final String body) {
        return new WithClause(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getParameters() {
                return parameters;
            }

            @Override
            public boolean isRecursive() {
                return isRecursive;
            }

            @Override
            public String getBody() {
                return body;
            }

            @Override
            public boolean hasParameters() {
                return Strings.isValid((String)parameters);
            }
        };
    }
}

