/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.CriteriaSet;
import org.eclipse.osee.orcs.db.internal.IdentityLocator;
import org.eclipse.osee.orcs.db.internal.search.tagger.HasTagProcessor;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagProcessor;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerComparator;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;

public class SqlHandlerFactoryImpl
implements SqlHandlerFactory {
    private static final SqlHandlerComparator HANDLER_COMPARATOR = new SqlHandlerComparator();
    private final Map<Class<? extends Criteria>, Class<? extends SqlHandler<?>>> handleMap;
    private final Log logger;
    private final IdentityLocator idService;
    private final TagProcessor tagProcessor;

    public SqlHandlerFactoryImpl(Log logger, IdentityLocator idService, TagProcessor tagProcessor, Map<Class<? extends Criteria>, Class<? extends SqlHandler<?>>> handleMap) {
        this.logger = logger;
        this.idService = idService;
        this.handleMap = handleMap;
        this.tagProcessor = tagProcessor;
    }

    @Override
    public List<SqlHandler<?>> createHandlers(CriteriaSet ... criteriaSet) throws OseeCoreException {
        return this.createHandlers(Arrays.asList(criteriaSet));
    }

    @Override
    public List<SqlHandler<?>> createHandlers(Iterable<CriteriaSet> criteriaSets) throws OseeCoreException {
        ArrayList handlers = new ArrayList();
        int level = 0;
        for (CriteriaSet criteriaSet : criteriaSets) {
            this.addHandlers(handlers, level, criteriaSet);
            ++level;
        }
        Collections.sort(handlers, HANDLER_COMPARATOR);
        return handlers;
    }

    private void addHandlers(List<SqlHandler<?>> handlers, int index, CriteriaSet criteriaSet) {
        for (Criteria criteria : criteriaSet) {
            SqlHandler<?> handler = this.createHandler(criteria);
            if (handler == null) continue;
            handler.setLevel(index);
            handlers.add(handler);
        }
    }

    @Override
    public SqlHandler<?> createHandler(Criteria criteria) throws OseeCoreException {
        Class<?> key = criteria.getClass();
        Class<? extends SqlHandler<?>> item = this.handleMap.get(key);
        SqlHandler<Criteria> toReturn = null;
        if (item != null) {
            toReturn = this.createHandler(criteria, item);
        }
        return toReturn;
    }

    private <C extends Criteria, H extends SqlHandler<C>> SqlHandler<C> createHandler(C criteria, Class<H> item) throws OseeCoreException {
        SqlHandler handler = null;
        try {
            handler = (SqlHandler)item.newInstance();
            handler.setData(criteria);
            handler.setIdentityService(this.idService);
            handler.setLogger(this.logger);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        if (handler instanceof HasTagProcessor) {
            ((HasTagProcessor)((Object)handler)).setTagProcessor(this.tagProcessor);
        }
        return handler;
    }
}

