/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.HasOptions;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.db.internal.sql.AliasEntry;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.QueryType;
import org.eclipse.osee.orcs.db.internal.sql.SqlAliasManager;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.WithClause;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.CharJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public abstract class AbstractSqlWriter
implements HasOptions {
    protected static final String AND_WITH_NEWLINES = "\n AND \n";
    private final StringBuilder output = new StringBuilder();
    private final List<String> tableEntries = new ArrayList<String>();
    private final List<WithClause> withClauses = new ArrayList<WithClause>();
    private final SqlAliasManager aliasManager = new SqlAliasManager();
    private final Log logger;
    private final SqlJoinFactory joinFactory;
    private final JdbcClient jdbcClient;
    private final SqlContext context;
    private final QueryType queryType;
    private int level = 0;

    public AbstractSqlWriter(Log logger, SqlJoinFactory joinFactory, JdbcClient jdbcClient, SqlContext context, QueryType queryType) {
        this.logger = logger;
        this.joinFactory = joinFactory;
        this.jdbcClient = jdbcClient;
        this.context = context;
        this.queryType = queryType;
    }

    public void build(SqlHandler<?> ... handlers) throws OseeCoreException {
        this.build(Arrays.asList(handlers));
    }

    public void build(List<SqlHandler<?>> handlers) throws OseeCoreException {
        Conditions.checkNotNullOrEmpty(handlers, (String)"SqlHandlers");
        this.reset();
        this.write(handlers);
        String sql = this.toString();
        this.context.setSql(sql);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Sql Writer - [%s]", new Object[]{this.context});
        }
    }

    protected void reset() {
        this.output.delete(0, this.output.length());
        this.context.getJoins().clear();
        this.context.getParameters().clear();
        this.tableEntries.clear();
        this.withClauses.clear();
        this.aliasManager.reset();
        this.level = 0;
    }

    public boolean isCountQueryType() {
        return QueryType.COUNT == this.queryType;
    }

    protected void write(Iterable<SqlHandler<?>> handlers) throws OseeCoreException {
        this.computeTables(handlers);
        this.computeWithClause(handlers);
        this.writeWithClause();
        this.writeSelect(handlers);
        this.write("\n FROM \n", new Object[0]);
        this.writeTables();
        this.write("\n WHERE \n", new Object[0]);
        this.writePredicates(handlers);
        if (this.toString().endsWith("\n WHERE \n")) {
            this.removeDanglingSeparator("\n WHERE \n");
        }
        this.writeGroupAndOrder();
    }

    protected void writeWithClause() throws OseeCoreException {
        if (Conditions.hasValues(this.withClauses)) {
            this.write("WITH", new Object[0]);
            int size = this.withClauses.size();
            int i = 0;
            while (i < size) {
                WithClause clause = this.withClauses.get(i);
                if (clause.isRecursive()) {
                    this.write(this.jdbcClient.getDbType().getRecursiveWithSql(), new Object[0]);
                }
                this.write(" ", new Object[0]);
                this.write(clause.getName(), new Object[0]);
                if (clause.hasParameters()) {
                    this.write(" ", new Object[0]);
                    this.write(clause.getParameters(), new Object[0]);
                }
                this.write(" AS ( \n", new Object[0]);
                this.write(clause.getBody(), new Object[0]);
                this.write("\n )", new Object[0]);
                if (i + 1 < size) {
                    this.write(", \n", new Object[0]);
                }
                ++i;
            }
            this.write("\n", new Object[0]);
        }
    }

    public void addWithClause(WithClause clause) {
        this.withClauses.add(clause);
    }

    protected void computeWithClause(Iterable<SqlHandler<?>> handlers) throws OseeCoreException {
        for (SqlHandler<?> handler : handlers) {
            this.setHandlerLevel(handler);
            handler.addWithTables(this);
        }
    }

    public SqlContext getContext() {
        return this.context;
    }

    protected abstract void writeSelect(Iterable<SqlHandler<?>> var1) throws OseeCoreException;

    public abstract String getWithClauseTxBranchFilter(String var1, boolean var2) throws OseeCoreException;

    public abstract String getTxBranchFilter(String var1) throws OseeCoreException;

    public abstract String getTxBranchFilter(String var1, boolean var2) throws OseeCoreException;

    protected abstract void writeGroupAndOrder() throws OseeCoreException;

    protected void writeTables() throws OseeCoreException {
        int size = this.tableEntries.size();
        int i = 0;
        while (i < size) {
            this.write(this.tableEntries.get(i), new Object[0]);
            if (i + 1 < size) {
                this.write(", ", new Object[0]);
            }
            ++i;
        }
    }

    protected void computeTables(Iterable<SqlHandler<?>> handlers) throws OseeCoreException {
        for (SqlHandler<?> handler : handlers) {
            this.setHandlerLevel(handler);
            handler.addTables(this);
        }
    }

    protected void setHandlerLevel(SqlHandler<?> handler) {
        this.level = handler.getLevel();
    }

    protected void writePredicates(Iterable<SqlHandler<?>> handlers) throws OseeCoreException {
        Iterator<SqlHandler<?>> iterator = handlers.iterator();
        while (iterator.hasNext()) {
            SqlHandler<?> handler = iterator.next();
            this.setHandlerLevel(handler);
            boolean modified = handler.addPredicates(this);
            if (!modified || !iterator.hasNext()) continue;
            this.writeAndLn();
        }
        this.removeDanglingSeparator(AND_WITH_NEWLINES);
    }

    public void writeAndLn() throws OseeCoreException {
        this.write(AND_WITH_NEWLINES, new Object[0]);
    }

    protected void removeDanglingSeparator(String token) {
        int length = this.output.length();
        int index = this.output.lastIndexOf(token);
        if (index == length - token.length()) {
            this.output.delete(index, length);
        }
    }

    protected boolean hasAlias(TableEnum table) {
        ObjectType type = this.getObjectType(table);
        return this.getAliasManager().hasAlias(this.level, table, type);
    }

    public List<String> getAliases(TableEnum table) {
        ObjectType type = this.getObjectType(table);
        return this.getAliasManager().getAliases(this.level, table, type);
    }

    public String getFirstAlias(TableEnum table) {
        ObjectType type = this.getObjectType(table);
        return this.getFirstAlias(this.level, table, type);
    }

    public String getFirstAlias(int level, TableEnum table, ObjectType type) {
        return this.getAliasManager().getFirstAlias(level, table, type);
    }

    public String getLastAlias(TableEnum table) {
        ObjectType type = this.getObjectType(table);
        return this.getLastAlias(table, type);
    }

    public String getLastAlias(TableEnum table, ObjectType type) {
        int level = this.getAliasManager().getLevel();
        return this.getAliasManager().getLastAlias(level, table, type);
    }

    public String getNextAlias(AliasEntry table) {
        ObjectType type = this.getObjectType(table);
        return this.getNextAlias(table, type);
    }

    private String getNextAlias(AliasEntry table, ObjectType type) {
        int level = this.getAliasManager().getLevel();
        return this.getAliasManager().getNextAlias(level, table, type);
    }

    private ObjectType getObjectType(AliasEntry entry) {
        ObjectType toReturn = ObjectType.UNKNOWN;
        if (entry instanceof TableEnum) {
            TableEnum table = (TableEnum)entry;
            switch (table) {
                case BRANCH_TABLE: {
                    toReturn = ObjectType.BRANCH;
                    break;
                }
                case TX_DETAILS_TABLE: {
                    toReturn = ObjectType.TX;
                    break;
                }
                case ARTIFACT_TABLE: {
                    toReturn = ObjectType.ARTIFACT;
                    break;
                }
                case ATTRIBUTE_TABLE: {
                    toReturn = ObjectType.ATTRIBUTE;
                    break;
                }
                case RELATION_TABLE: {
                    toReturn = ObjectType.RELATION;
                    break;
                }
            }
        }
        return toReturn;
    }

    public int nextAliasLevel() {
        return this.getAliasManager().nextLevel();
    }

    public SqlAliasManager getAliasManager() {
        return this.aliasManager;
    }

    public void addTable(String table) {
        this.tableEntries.add(table);
    }

    public String getOrCreateTableAlias(TableEnum table) {
        String alias = this.getFirstAlias(table);
        if (alias == null) {
            alias = this.addTable(table);
        }
        return alias;
    }

    public String getOrCreateTableAlias(TableEnum table, ObjectType objectType) {
        String alias = this.getFirstAlias(table);
        if (alias == null) {
            alias = this.addTable(table, objectType);
        }
        return alias;
    }

    public String addTable(AliasEntry table) {
        String alias = this.getNextAlias(table);
        this.tableEntries.add(String.format("%s %s", table.getName(), alias));
        return alias;
    }

    public String addTable(AliasEntry table, ObjectType objectType) {
        String alias = this.getNextAlias(table, objectType);
        this.tableEntries.add(String.format("%s %s", table.getName(), alias));
        return alias;
    }

    public void write(String data, Object ... params) throws OseeCoreException {
        if (params != null && params.length > 0) {
            this.output.append(String.format(data, params));
        } else {
            this.output.append(data);
        }
    }

    public void writeEquals(String table1, String table2, String column) {
        this.write("%s.%s = %s.%s", table1, column, table2, column);
    }

    public void addParameter(Object data) {
        this.getContext().getParameters().add(data);
    }

    private void addJoin(AbstractJoinQuery join) {
        this.getContext().getJoins().add(join);
    }

    public CharJoinQuery writeCharJoin(Collection<String> ids) {
        CharJoinQuery joinQuery = this.joinFactory.createCharJoinQuery();
        ids.forEach(id -> joinQuery.add((String)id));
        this.addJoin(joinQuery);
        return joinQuery;
    }

    public IdJoinQuery writeJoin(Collection<? extends Id> ids) {
        IdJoinQuery joinQuery = this.joinFactory.createIdJoinQuery();
        ids.forEach(id -> joinQuery.add(id.getId()));
        this.addJoin(joinQuery);
        return joinQuery;
    }

    public IdJoinQuery writeIdJoin(Collection<? extends Number> ids) {
        IdJoinQuery joinQuery = this.joinFactory.createIdJoinQuery();
        ids.forEach(id -> joinQuery.add((Number)id));
        this.addJoin(joinQuery);
        return joinQuery;
    }

    public Options getOptions() {
        return this.getContext().getOptions();
    }

    protected String getSqlHint() throws OseeCoreException {
        String hint = "";
        if (!Conditions.hasValues(this.withClauses) && this.jdbcClient != null && this.jdbcClient.getConfig() != null) {
            hint = OseeSql.Strings.getHintsOrdered((Properties)this.jdbcClient.getConfig().getDbProps());
        }
        return hint;
    }

    public String toString() {
        return this.output.toString();
    }

    public void writePatternMatch(String field, String expression) throws OseeCoreException {
        String pattern = this.jdbcClient.getDbType().getRegularExpMatchSql();
        this.write(pattern, field, expression);
    }
}

