/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.MatchLocation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class SecondPassScanner {
    private InputStream input;
    private final QueryOption delimiter;
    private String next;
    private int start;
    private int end = -1;
    private int bytesRead = 0;
    private boolean eof = false;
    private final StringBuilder buffer = new StringBuilder();

    public SecondPassScanner(InputStream input, QueryOption delimiter) {
        this.input = input;
        this.delimiter = delimiter;
    }

    public SecondPassScanner(String input, QueryOption delimiter) {
        try {
            this.input = Lib.stringToInputStream((String)input);
        }
        catch (UnsupportedEncodingException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        this.delimiter = delimiter;
    }

    private boolean isMultibyteStart(int read) {
        return read >= 194 && read <= 253;
    }

    private boolean isMultibyte(int read) {
        return read >= 128 && read <= 191;
    }

    public boolean hasNext() {
        int read = -1;
        this.buffer.delete(0, this.buffer.length());
        while (!this.eof) {
            try {
                read = this.input.read();
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
            if (this.isMultibyte(read)) continue;
            if (read == -1) {
                this.eof = true;
            } else {
                ++this.bytesRead;
            }
            if (!this.isMultibyteStart(read) && this.processChar(read)) break;
        }
        this.next = this.buffer.toString();
        return Strings.isValid((String)this.next);
    }

    private boolean processChar(int read) {
        boolean done = false;
        switch (this.delimiter) {
            case TOKEN_DELIMITER__ANY: {
                if (Character.isLetterOrDigit(read)) {
                    this.buffer.append((char)read);
                    break;
                }
                if (this.buffer.length() == 0) break;
                this.end = this.start + this.buffer.length();
                done = true;
                break;
            }
            case TOKEN_DELIMITER__EXACT: {
                if (read != -1) {
                    this.end = this.bytesRead;
                    this.buffer.append((char)read);
                }
                done = true;
                break;
            }
            case TOKEN_DELIMITER__WHITESPACE: {
                if (Character.isWhitespace((char)read) || read == -1) {
                    if (this.buffer.length() == 0) break;
                    this.end = this.start + this.buffer.length();
                    done = true;
                    break;
                }
                this.buffer.append((char)read);
                break;
            }
        }
        if (this.buffer.length() == 1) {
            this.start = this.bytesRead - 1;
        }
        return done;
    }

    public String next() {
        return this.next;
    }

    public MatchLocation match() {
        return new MatchLocation(this.start, this.end);
    }

    public void close() {
        Lib.close((Closeable)this.input);
    }
}

