/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.util;

import com.google.common.collect.Lists;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.executor.admin.HasCancellation;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.MatchLocation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.BinaryDataProxy;
import org.eclipse.osee.orcs.core.ds.CharacterDataProxy;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.IndexedResource;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.search.tagger.Tagger;
import org.eclipse.osee.orcs.db.internal.search.tagger.TaggingEngine;

public class AttributeDataMatcher {
    private final Log logger;
    private final TaggingEngine engine;
    private final AttributeTypes attrTypes;

    public AttributeDataMatcher(Log logger, TaggingEngine engine, AttributeTypes attrTypes) {
        this.logger = logger;
        this.engine = engine;
        this.attrTypes = attrTypes;
    }

    protected Tagger getTagger(String taggerId) throws OseeCoreException {
        Tagger toReturn = null;
        if (Strings.isValid((String)taggerId)) {
            toReturn = this.engine.getTagger(taggerId);
        }
        return toReturn;
    }

    public List<MatchLocation> process(HasCancellation cancellation, AttributeData data, Collection<String> valuesToMatch, Collection<AttributeTypeId> typesFilter, QueryOption ... options) throws Exception {
        this.logger.debug("Attribute Data match for attr[%s] - [%s]", new Object[]{data.getLocalId(), valuesToMatch});
        if (Conditions.hasValues((Object[])options)) {
            return this.matchTokenizedValue(cancellation, data, valuesToMatch, typesFilter, options);
        }
        return this.matchValuesExactly(cancellation, data, valuesToMatch);
    }

    private void checkCancelled(HasCancellation cancellation) {
        if (cancellation != null) {
            cancellation.checkForCancelled();
        }
    }

    private List<MatchLocation> matchValuesExactly(HasCancellation cancellation, AttributeData data, Iterable<String> valuesToMatch) throws Exception {
        String value = this.getValue(data);
        LinkedList matched = Lists.newLinkedList();
        for (String toMatch : valuesToMatch) {
            this.checkCancelled(cancellation);
            if (!value.equals(toMatch) && (Strings.isValid((String)value) || Strings.isValid((String)toMatch))) continue;
            MatchLocation matchLocation = new MatchLocation(1, value.length());
            matched.add(matchLocation);
        }
        return matched;
    }

    private List<MatchLocation> matchTokenizedValue(HasCancellation cancellation, AttributeData data, Iterable<String> valuesToMatch, Collection<AttributeTypeId> typesFilter, QueryOption ... options) {
        AttributeIndexedResource source = this.adapt(data);
        AttributeTypeId attrType = AttributeTypeId.valueOf((Long)source.getTypeUuid());
        if (typesFilter.contains(attrType)) {
            this.checkCancelled(cancellation);
            String taggerId = this.attrTypes.getTaggerId(attrType);
            Tagger tagger = this.getTagger(taggerId);
            if (tagger != null) {
                this.checkCancelled(cancellation);
                try {
                    LinkedList matched = Lists.newLinkedList();
                    for (String toMatch : valuesToMatch) {
                        matched.addAll(tagger.find((InputSupplier<? extends InputStream>)source, toMatch, true, options));
                    }
                    return matched;
                }
                catch (Exception ex) {
                    this.logger.error((Throwable)ex, "Error searching attrId [%d] gamma [%d]", new Object[]{data.getLocalId(), data.getVersion().getGammaId()});
                }
            }
        }
        return null;
    }

    private AttributeIndexedResource adapt(AttributeData data) {
        return new AttributeIndexedResource(data);
    }

    private String getValue(AttributeData data) throws OseeCoreException {
        String value = "";
        DataProxy dataProxy = data.getDataProxy();
        value = dataProxy instanceof CharacterDataProxy ? ((CharacterDataProxy)dataProxy).getValueAsString() : dataProxy.toString();
        return value;
    }

    private final class AttributeIndexedResource
    implements IndexedResource {
        private final AttributeData attrData;

        public AttributeIndexedResource(AttributeData attrData) {
            this.attrData = attrData;
        }

        public long getTypeUuid() {
            return this.attrData.getTypeUuid();
        }

        public long getGammaId() {
            return this.attrData.getVersion().getGammaId();
        }

        public InputStream getInput() throws IOException {
            ByteArrayInputStream stream = null;
            DataProxy dataProxy = this.attrData.getDataProxy();
            if (dataProxy instanceof BinaryDataProxy) {
                ByteBuffer valueAsBytes;
                try {
                    valueAsBytes = ((BinaryDataProxy)dataProxy).getValueAsBytes();
                }
                catch (OseeCoreException ex) {
                    throw new IOException(ex);
                }
                stream = new ByteArrayInputStream(valueAsBytes.array());
            } else {
                String value = null;
                if (dataProxy instanceof CharacterDataProxy) {
                    try {
                        value = ((CharacterDataProxy)dataProxy).getValueAsString();
                    }
                    catch (OseeCoreException ex) {
                        throw new IOException(ex);
                    }
                } else {
                    value = dataProxy.toString();
                }
                stream = new ByteArrayInputStream(value.getBytes("UTF-8"));
            }
            return stream;
        }
    }
}

