/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.tagger;

import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagProcessor;
import org.eclipse.osee.orcs.db.internal.search.tagger.Tagger;

public class TaggingEngine {
    private final Map<String, Tagger> taggers;
    private final TagProcessor tagProcessor;

    public TaggingEngine(Map<String, Tagger> taggers, TagProcessor tagProcessor) {
        this.taggers = taggers;
        this.tagProcessor = tagProcessor;
    }

    public TagProcessor getTagProcessor() {
        return this.tagProcessor;
    }

    public Tagger getDefaultTagger() throws OseeCoreException {
        return this.getTagger("DefaultAttributeTaggerProvider");
    }

    private String normalize(String alias) {
        String key = alias;
        if (Strings.isValid((String)key) && key.contains(".")) {
            key = Lib.getExtension((String)key);
        }
        return key;
    }

    public boolean hasTagger(String taggerId) {
        String key = this.normalize(taggerId);
        Tagger tagger = this.taggers.get(key);
        return tagger != null;
    }

    public Tagger getTagger(String taggerId) throws OseeCoreException {
        String key = this.normalize(taggerId);
        Tagger tagger = this.taggers.get(key);
        Conditions.checkNotNull((Object)tagger, (String)"tagger", (String)"Unable to find tagger for [%s]", (Object[])new Object[]{taggerId});
        return tagger;
    }
}

