/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.tagger;

import java.io.InputStream;
import java.util.Scanner;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.db.internal.search.tagger.Language;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagCollector;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagEncoder;
import org.eclipse.osee.orcs.db.internal.search.util.WordsUtil;

public class TagProcessor {
    private final Language language;
    private final TagEncoder encoder;

    public TagProcessor(Language language, TagEncoder encoder) {
        this.language = language;
        this.encoder = encoder;
    }

    public void collectFromString(String value, TagCollector tagCollector) {
        if (Strings.isValid((String)value)) {
            Scanner scanner = new Scanner(value);
            while (scanner.hasNext()) {
                this.processWord(scanner.next(), tagCollector);
            }
        }
    }

    public void collectFromInputStream(InputStream inputStream, TagCollector tagCollector) {
        if (inputStream != null) {
            try (Scanner scanner = new Scanner(inputStream, "UTF-8");){
                while (scanner.hasNext()) {
                    this.processWord(scanner.next(), tagCollector);
                }
            }
        }
    }

    public void collectFromScanner(Scanner sourceScanner, TagCollector tagCollector) {
        try {
            while (sourceScanner.hasNext()) {
                String entry = sourceScanner.next();
                if (entry.length() <= 0) continue;
                Scanner innerScanner = new Scanner(entry);
                while (innerScanner.hasNext()) {
                    String entry1 = innerScanner.next();
                    this.processWord(entry1, tagCollector);
                }
            }
        }
        catch (Exception exception) {}
    }

    private void processWord(String original, TagCollector tagCollector) {
        if (Strings.isValid((String)original) && (original.length() >= 2 || WordsUtil.countPuntuation(original) == 0)) {
            original = original.toLowerCase();
            String[] stringArray = WordsUtil.splitOnPunctuation(original);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String toEncode = stringArray[n2];
                if (this.language.isWord(toEncode)) {
                    String target = this.language.toSingular(toEncode);
                    this.encoder.encode(target, tagCollector);
                }
                ++n2;
            }
        }
    }

    public static char[] normalizeWord(String toSearch) {
        boolean lastCharacterAddedWasWhiteSpace = false;
        StringBuilder searchString = new StringBuilder();
        int index = 0;
        while (index < toSearch.length()) {
            char currChar = toSearch.charAt(index);
            if ((currChar = Character.toLowerCase(currChar)) != '\r' && currChar != '\n') {
                if (WordsUtil.isPunctuationOrApostrophe(currChar)) {
                    currChar = ' ';
                }
                if (Character.isWhitespace(currChar)) {
                    if (!lastCharacterAddedWasWhiteSpace) {
                        searchString.append(currChar);
                        lastCharacterAddedWasWhiteSpace = true;
                    }
                } else {
                    searchString.append(currChar);
                    lastCharacterAddedWasWhiteSpace = false;
                }
            }
            ++index;
        }
        return searchString.toString().trim().toCharArray();
    }
}

