/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.language;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.search.tagger.Language;

public class EnglishLanguage
implements Language {
    private static final String VOWELS = "aeiou";
    private static final String IES_ENDING = "ies";
    private static final String OES_ENDING = "oes";
    private static final String ES_ENDING = "es";
    private static final String S_ENDING = "s";
    private static final String VES_ENDING = "ves";
    private static final String[] SPECIAL_ES_ENDING_CASES = new String[]{"ss", "sh", "ch", "x"};
    private static final Collection<String> wordsToSkip = Arrays.asList("ies", "s", "oes", "es");
    private final Properties dictionary = new Properties();
    private boolean isInitialized = false;
    private final Log logger;

    public EnglishLanguage(Log logger) {
        this.logger = logger;
    }

    private boolean hasConstantBeforeEnding(String word, String ending) {
        if (!word.equals(ending)) {
            String remainder = word.substring(word.length() - (ending.length() + 1));
            return VOWELS.indexOf(remainder, 1) < 0;
        }
        return false;
    }

    private boolean hasEitherSequenceBeforeEnding(String word, String ending, String ... sequences) {
        boolean toReturn = false;
        String remainder = word.substring(0, word.length() - ending.length());
        String[] stringArray = sequences;
        int n = sequences.length;
        int n2 = 0;
        while (n2 < n) {
            String sequence = stringArray[n2];
            toReturn |= remainder.endsWith(sequence);
            ++n2;
        }
        return toReturn;
    }

    private static String replaceEndingWith(String word, String ending, String replaceWith) {
        return String.valueOf(word.substring(0, word.length() - ending.length())) + replaceWith;
    }

    private String stripPossesive(String original) {
        String toReturn = original;
        if (original != null && original.length() > 0) {
            if (original.lastIndexOf(39) == original.length() - 1) {
                toReturn = EnglishLanguage.replaceEndingWith(original, "'", "");
            } else if (original.endsWith("'s")) {
                toReturn = EnglishLanguage.replaceEndingWith(original, "'s", "");
            }
        }
        return toReturn;
    }

    @Override
    public boolean isWord(String rawText) {
        return !wordsToSkip.contains(rawText);
    }

    @Override
    public String toSingular(String rawText) {
        String word = this.stripPossesive(rawText);
        String toReturn = this.getSingular(word = word.toLowerCase());
        if (toReturn == null) {
            if (word.endsWith(IES_ENDING) && this.hasConstantBeforeEnding(word, IES_ENDING)) {
                toReturn = EnglishLanguage.replaceEndingWith(word, IES_ENDING, "y");
            } else if (word.endsWith(OES_ENDING) && this.hasConstantBeforeEnding(word, OES_ENDING)) {
                toReturn = EnglishLanguage.replaceEndingWith(word, OES_ENDING, "o");
            } else if (word.endsWith(ES_ENDING) && this.hasConstantBeforeEnding(word, ES_ENDING)) {
                String replaceWith = "e";
                String ending = ES_ENDING;
                if (this.hasEitherSequenceBeforeEnding(word, ES_ENDING, SPECIAL_ES_ENDING_CASES)) {
                    replaceWith = Strings.emptyString();
                } else if (this.hasEitherSequenceBeforeEnding(word, ES_ENDING, "v")) {
                    ending = VES_ENDING;
                    replaceWith = "f";
                }
                toReturn = EnglishLanguage.replaceEndingWith(word, ending, replaceWith);
            } else {
                toReturn = word.endsWith(S_ENDING) ? word.substring(0, word.length() - 1) : word;
            }
        }
        return toReturn;
    }

    public String getSingular(String word) {
        this.ensureIntialized();
        return this.dictionary.getProperty(word);
    }

    private synchronized void ensureIntialized() {
        block6: {
            if (!this.isInitialized) {
                this.isInitialized = true;
                BufferedInputStream inputStream = null;
                try {
                    try {
                        URL url = this.getClass().getResource("pluralToSingularExceptions.xml");
                        inputStream = new BufferedInputStream(url.openStream());
                        this.dictionary.loadFromXML(inputStream);
                    }
                    catch (Exception ex) {
                        this.logger.error((Throwable)ex, "Unable to process plural to singular exceptions file.", new Object[0]);
                        Lib.close((Closeable)inputStream);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    Lib.close(inputStream);
                    throw throwable;
                }
                Lib.close((Closeable)inputStream);
            }
        }
    }
}

