/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.framework.resource.management.StandardOptions;
import org.eclipse.osee.orcs.core.ds.IndexedResource;

public class IndexerDataSourceImpl
implements IndexedResource {
    private final IResourceManager resourceManager;
    private final int localId;
    private final long typeUuid;
    private final long gammaId;
    private final String value;
    private final String uri;

    public IndexerDataSourceImpl(IResourceManager resourceManager, int localId, long typeUuid, long gammaId, String value, String uri) {
        this.resourceManager = resourceManager;
        this.localId = localId;
        this.typeUuid = typeUuid;
        this.gammaId = gammaId;
        this.value = value;
        this.uri = uri;
    }

    public long getGammaId() {
        return this.gammaId;
    }

    public long getTypeUuid() {
        return this.typeUuid;
    }

    private String getStringValue() {
        return this.value;
    }

    private String getUri() {
        return this.uri;
    }

    private boolean isUriValid() {
        boolean toReturn = false;
        try {
            URI uri;
            String value = this.getUri();
            if (Strings.isValid((String)value) && (uri = new URI(value)).toASCIIString().startsWith("attr")) {
                toReturn = true;
            }
        }
        catch (Exception exception) {}
        return toReturn;
    }

    public InputStream getInput() throws IOException {
        InputStream toReturn = null;
        if (this.isUriValid()) {
            try {
                PropertyStore options = new PropertyStore();
                options.put(StandardOptions.DecompressOnAquire.name(), true);
                IResourceLocator locator = this.resourceManager.getResourceLocator(this.getUri());
                IResource resource = this.resourceManager.acquire(locator, options);
                toReturn = resource.getContent();
            }
            catch (OseeCoreException ex) {
                throw new IOException(ex);
            }
        } else if (Strings.isValid((String)this.getStringValue())) {
            toReturn = new ByteArrayInputStream(this.getStringValue().getBytes("UTF-8"));
        }
        return toReturn;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.gammaId ^ this.gammaId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IndexedResource) {
            IndexedResource other = (IndexedResource)obj;
            return this.getGammaId() == other.getGammaId();
        }
        return false;
    }

    public String toString() {
        return "IndexerDataSourceImpl [localId=" + this.localId + ", typeUuid=" + this.typeUuid + ", gammaId=" + this.gammaId + ", uri=" + this.uri + ", value=" + this.value + "]";
    }
}

