/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer.callable;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;

public final class PurgeAllTagsDatabaseCallable
extends AbstractDatastoreCallable<Integer> {
    private static final String SEARCH_TAG_TABLE_NAME = "osee_search_tags";

    public PurgeAllTagsDatabaseCallable(Log logger, OrcsSession session, JdbcClient jdbcClient) {
        super(logger, session, jdbcClient);
    }

    public Integer call() throws Exception {
        this.getLogger().warn("Purging all search tags", new Object[0]);
        String cmd = this.isTruncateSupported() ? "TRUNCATE TABLE" : "DELETE FROM";
        String deleteSql = String.format("%s %s", cmd, SEARCH_TAG_TABLE_NAME);
        try {
            return this.getJdbcClient().runPreparedUpdate(deleteSql, new Object[0]);
        }
        catch (OseeCoreException ex) {
            this.getLogger().info((Throwable)ex, "Error clearing: %s", new Object[]{deleteSql});
            throw ex;
        }
    }

    private boolean isTruncateSupported() throws OseeCoreException {
        boolean isTruncateSupported;
        block18: {
            isTruncateSupported = false;
            try (JdbcConnection connection = this.getJdbcClient().getConnection();){
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet resultSet = null;
                try {
                    try {
                        resultSet = metaData.getTablePrivileges(null, null, SEARCH_TAG_TABLE_NAME);
                        while (resultSet.next()) {
                            String value = resultSet.getString("PRIVILEGE");
                            if (!"TRUNCATE".equalsIgnoreCase(value)) continue;
                            isTruncateSupported = true;
                            break;
                        }
                    }
                    catch (SQLException ex1) {
                        this.getLogger().info((Throwable)ex1, "Error determining truncate support", new Object[0]);
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    throw throwable;
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return isTruncateSupported;
    }
}

