/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.IndexerData;
import org.eclipse.osee.orcs.core.ds.QueryEngineIndexer;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.data.BranchReadable;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexerCollectorNotifier;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexingTaskConsumer;
import org.eclipse.osee.orcs.db.internal.search.indexer.callable.DeleteTagSetDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.callable.IndexerDatabaseStatisticsCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.callable.PurgeAllTagsDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.callable.producer.IndexAllInQueueCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.callable.producer.IndexBranchesDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.callable.producer.IndexerDatabaseCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.IndexerCollector;

public class QueryEngineIndexerImpl
implements QueryEngineIndexer {
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;
    private final IndexingTaskConsumer consumer;
    private final IndexerCollectorNotifier systemCollector;

    public QueryEngineIndexerImpl(Log logger, JdbcClient jdbcClient, SqlJoinFactory joinFactory, IndexingTaskConsumer indexingConsumer) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
        this.consumer = indexingConsumer;
        this.systemCollector = new IndexerCollectorNotifier(logger);
    }

    public CancellableCallable<Integer> deleteIndexByQueryId(OrcsSession session, int queueId) {
        return new DeleteTagSetDatabaseTxCallable(this.logger, session, this.jdbcClient, queueId);
    }

    public CancellableCallable<Integer> purgeAllIndexes(OrcsSession session) {
        return new PurgeAllTagsDatabaseCallable(this.logger, session, this.jdbcClient);
    }

    public CancellableCallable<IndexerData> getIndexerData(OrcsSession session) {
        return new IndexerDatabaseStatisticsCallable(this.logger, session, this.jdbcClient);
    }

    public CancellableCallable<Integer> indexBranches(OrcsSession session, AttributeTypes types, Collection<? extends AttributeTypeId> typeToTag, Set<BranchReadable> branches, boolean indexOnlyMissing, IndexerCollector ... collector) {
        return new IndexBranchesDatabaseCallable(this.logger, session, this.jdbcClient, this.joinFactory, types, this.consumer, this.merge(collector), typeToTag, branches, indexOnlyMissing);
    }

    public CancellableCallable<Integer> indexAllFromQueue(OrcsSession session, AttributeTypes types, IndexerCollector ... collector) {
        return new IndexAllInQueueCallable(this.logger, session, this.jdbcClient, this.joinFactory, types, this.consumer, this.merge(collector));
    }

    public CancellableCallable<List<Future<?>>> indexResources(OrcsSession session, AttributeTypes types, Iterable<Long> datas, IndexerCollector ... collector) {
        return new IndexerDatabaseCallable(this.logger, session, this.jdbcClient, this.joinFactory, types, this.consumer, this.merge(collector), false, 1000, datas);
    }

    public void indexAttrTypeIds(OrcsSession session, AttributeTypes types, Iterable<Long> attrTypeIds) {
        String GAMMAS_BY_TYPE = "select gamma_id from osee_attribute where attr_type_id = ?";
        LinkedList<Long> gammaIds = new LinkedList<Long>();
        for (Long attributeType : attrTypeIds) {
            Throwable throwable = null;
            Object var9_11 = null;
            try (JdbcStatement chStmt = this.jdbcClient.getStatement();){
                chStmt.runPreparedQuery(10000, GAMMAS_BY_TYPE, new Object[]{attributeType});
                while (chStmt.next()) {
                    gammaIds.add(chStmt.getLong("gamma_id"));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            try {
                new IndexerDatabaseCallable(this.logger, session, this.jdbcClient, this.joinFactory, types, this.consumer, null, false, 1000, gammaIds).call();
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
            System.out.println(String.format("Processed %d gammas for type %d", gammaIds.size(), attributeType));
            gammaIds.clear();
        }
    }

    private IndexerCollector merge(IndexerCollector ... collectors) {
        IndexerCollectorNotifier toReturn = this.systemCollector;
        if (collectors != null && collectors.length > 0) {
            IndexerCollectorNotifier notifier = new IndexerCollectorNotifier(this.logger);
            notifier.addCollector(this.systemCollector);
            IndexerCollector[] indexerCollectorArray = collectors;
            int n = collectors.length;
            int n2 = 0;
            while (n2 < n) {
                IndexerCollector collector = indexerCollectorArray[n2];
                notifier.addCollector(collector);
                ++n2;
            }
        }
        return toReturn;
    }

    public void addCollector(IndexerCollector collector) {
        this.systemCollector.addCollector(collector);
    }

    public void removeCollector(IndexerCollector collector) {
        this.systemCollector.removeCollector(collector);
    }
}

