/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.sql.Timestamp;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaDateRange;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;

public class TxDateRangeSqlHandler
extends SqlHandler<CriteriaDateRange> {
    private CriteriaDateRange criteria;
    private String txAlias;

    @Override
    public void setData(CriteriaDateRange criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> branchAliases = writer.getAliases(TableEnum.TX_DETAILS_TABLE);
        this.txAlias = branchAliases.isEmpty() ? writer.addTable(TableEnum.TX_DETAILS_TABLE) : branchAliases.iterator().next();
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        Timestamp from = this.criteria.getFrom();
        Timestamp to = this.criteria.getTo();
        writer.write(this.txAlias, new Object[0]);
        writer.write(".time >= ? and ", new Object[0]);
        writer.write(this.txAlias, new Object[0]);
        writer.write(".time <= ? ", new Object[0]);
        writer.addParameter(from);
        writer.addParameter(to);
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.TX_DATE.ordinal();
    }
}

