/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaCommitIds;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;

public class TxCommitIdsSqlHandler
extends SqlHandler<CriteriaCommitIds> {
    private CriteriaCommitIds criteria;
    private String txdAlias;
    private String jIdAlias;

    @Override
    public void setData(CriteriaCommitIds criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> aliases;
        if (this.criteria.getIds().size() > 1) {
            this.jIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.txdAlias = (aliases = writer.getAliases(TableEnum.TX_DETAILS_TABLE)).isEmpty() ? writer.addTable(TableEnum.TX_DETAILS_TABLE) : aliases.iterator().next();
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        Collection ids = this.criteria.getIds();
        if (ids.size() > 1) {
            if (ids.contains(null)) {
                throw new OseeArgumentException("cannot specify null commit id as part of a multiple value request", new Object[0]);
            }
            IdJoinQuery joinQuery = writer.writeIdJoin(ids);
            writer.write(this.txdAlias, new Object[0]);
            writer.write(".commit_art_id = ", new Object[0]);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".id AND ", new Object[0]);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".query_id = ?", new Object[0]);
            writer.addParameter(joinQuery.getQueryId());
        } else {
            Integer theValue = (Integer)ids.iterator().next();
            writer.write(this.txdAlias, new Object[0]);
            if (theValue == null) {
                writer.write(".commit_art_id is null", new Object[0]);
            } else {
                writer.write(".commit_art_id = ?", new Object[0]);
                writer.addParameter(theValue);
            }
        }
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.TX_ID.ordinal();
    }
}

