/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaTxArtifactIds;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class TxArtifactIdSqlHandler
extends SqlHandler<CriteriaTxArtifactIds> {
    private CriteriaTxArtifactIds criteria;
    private String txdAlias;
    private String artAlias;
    private String jIdAlias;
    private AbstractJoinQuery joinQuery;

    @Override
    public void setData(CriteriaTxArtifactIds criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> aliases;
        if (this.criteria.hasMultiple()) {
            this.jIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.txdAlias = (aliases = writer.getAliases(TableEnum.TX_DETAILS_TABLE)).isEmpty() ? writer.addTable(TableEnum.TX_DETAILS_TABLE) : aliases.iterator().next();
        aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        this.artAlias = aliases.isEmpty() ? writer.addTable(TableEnum.ARTIFACT_TABLE) : aliases.iterator().next();
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        Collection ids = this.criteria.getIds();
        if (this.criteria.hasMultiple()) {
            this.joinQuery = writer.writeJoin(ids);
            writer.write(this.artAlias, new Object[0]);
            writer.write(".art_id = ", new Object[0]);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".id AND ", new Object[0]);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".query_id = ?", new Object[0]);
            writer.addParameter(this.joinQuery.getQueryId());
        } else {
            writer.write(this.artAlias, new Object[0]);
            writer.write(".art_id = ?", new Object[0]);
            writer.addParameter(this.criteria.getId());
        }
        writer.write(" AND ", new Object[0]);
        writer.write(this.artAlias, new Object[0]);
        writer.write(".art_id = ", new Object[0]);
        writer.write(this.txdAlias, new Object[0]);
        writer.write(".author", new Object[0]);
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ARTIFACT_GUID.ordinal();
    }
}

