/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeSideNotExists;
import org.eclipse.osee.orcs.db.internal.search.handlers.AbstractRelationSqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;

public class RelationTypeSideNotExistsSqlHandler
extends AbstractRelationSqlHandler<CriteriaRelationTypeSideNotExists> {
    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        super.addPredicates(writer);
        RelationTypeSide type = ((CriteriaRelationTypeSideNotExists)this.criteria).getType();
        writer.write("NOT EXISTS (SELECT 1 FROM ", new Object[0]);
        writer.write(TableEnum.RELATION_TABLE.getName(), new Object[0]);
        writer.write(" rel, ", new Object[0]);
        writer.write(TableEnum.TXS_TABLE.getName(), new Object[0]);
        writer.write(" txs WHERE rel.rel_link_type_id = ?", new Object[0]);
        writer.addParameter(type.getGuid());
        List<String> aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        String side = type.getSide().isSideA() ? "a" : "b";
        writer.writeAndLn();
        int aSize = aliases.size();
        int index = 0;
        while (index < aSize) {
            String artAlias = aliases.get(index);
            writer.write("rel.", new Object[0]);
            writer.write(side, new Object[0]);
            writer.write("_art_id = ", new Object[0]);
            writer.write(artAlias, new Object[0]);
            writer.write(".art_id", new Object[0]);
            if (index + 1 < aSize) {
                writer.writeAndLn();
            }
            ++index;
        }
        writer.writeAndLn();
        writer.write("rel.gamma_id = txs.gamma_id", new Object[0]);
        writer.writeAndLn();
        writer.write(writer.getTxBranchFilter("txs"), new Object[0]);
        writer.write(")", new Object[0]);
        return true;
    }
}

