/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeSideExists;
import org.eclipse.osee.orcs.db.internal.search.handlers.AbstractRelationSqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;

public class RelationTypeSideExistsSqlHandler
extends AbstractRelationSqlHandler<CriteriaRelationTypeSideExists> {
    private String relAlias;
    private String txsAlias;

    @Override
    public void addTables(AbstractSqlWriter writer) {
        super.addTables(writer);
        this.relAlias = writer.addTable(TableEnum.RELATION_TABLE);
        this.txsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.RELATION);
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        String side;
        super.addPredicates(writer);
        RelationTypeSide type = ((CriteriaRelationTypeSideExists)this.criteria).getType();
        writer.write(this.relAlias, new Object[0]);
        writer.write(".rel_link_type_id = ?", new Object[0]);
        writer.addParameter(type.getGuid());
        List<String> aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        String string = side = type.getSide().isSideA() ? "a" : "b";
        if (!aliases.isEmpty()) {
            writer.writeAndLn();
            int aSize = aliases.size();
            int index = 0;
            while (index < aSize) {
                String artAlias = aliases.get(index);
                writer.write(this.relAlias, new Object[0]);
                writer.write(".", new Object[0]);
                writer.write(side, new Object[0]);
                writer.write("_art_id = ", new Object[0]);
                writer.write(artAlias, new Object[0]);
                writer.write(".art_id", new Object[0]);
                if (index + 1 < aSize) {
                    writer.writeAndLn();
                }
                ++index;
            }
        }
        writer.writeAndLn();
        writer.write(this.relAlias, new Object[0]);
        writer.write(".gamma_id = ", new Object[0]);
        writer.write(this.txsAlias, new Object[0]);
        writer.write(".gamma_id", new Object[0]);
        writer.writeAndLn();
        writer.write(writer.getTxBranchFilter(this.txsAlias), new Object[0]);
        return true;
    }
}

