/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeFollow;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.SqlAliasManager;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;

public class RelationTypeFollowSqlHandler
extends SqlHandler<CriteriaRelationTypeFollow> {
    private CriteriaRelationTypeFollow criteria;
    private String artAlias0;
    private String txsAlias0;
    private String relAlias1;
    private String txsAlias1;
    private String artAlias2;
    private String txsAlias2;

    @Override
    public void setData(CriteriaRelationTypeFollow criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) throws OseeCoreException {
        List<String> artAliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        if (artAliases.isEmpty()) {
            this.artAlias0 = writer.addTable(TableEnum.ARTIFACT_TABLE);
            this.txsAlias0 = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
        } else {
            this.artAlias0 = artAliases.iterator().next();
        }
        this.relAlias1 = writer.addTable(TableEnum.RELATION_TABLE);
        this.txsAlias1 = writer.addTable(TableEnum.TXS_TABLE, ObjectType.RELATION);
        String branchAlias = writer.getFirstAlias(TableEnum.BRANCH_TABLE);
        int newLevel = writer.nextAliasLevel();
        this.artAlias2 = writer.addTable(TableEnum.ARTIFACT_TABLE);
        this.txsAlias2 = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
        if (Strings.isValid((String)branchAlias)) {
            SqlAliasManager aliasManager = writer.getAliasManager();
            aliasManager.putAlias(newLevel, TableEnum.BRANCH_TABLE, ObjectType.BRANCH, branchAlias);
        }
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        boolean includeDeletedRelations = OptionsUtil.areDeletedRelationsIncluded((Options)writer.getOptions());
        RelationTypeSide typeSide = this.criteria.getType();
        if (this.txsAlias0 != null && this.artAlias0 != null) {
            writer.write(this.artAlias0, new Object[0]);
            writer.write(".gamma_id = ", new Object[0]);
            writer.write(this.txsAlias0, new Object[0]);
            writer.write(".gamma_id", new Object[0]);
            writer.write(" AND ", new Object[0]);
            writer.write(writer.getTxBranchFilter(this.txsAlias0, includeDeletedRelations), new Object[0]);
            writer.write("\n AND \n", new Object[0]);
        }
        writer.write(this.relAlias1, new Object[0]);
        writer.write(".rel_link_type_id = ?", new Object[0]);
        writer.addParameter(typeSide.getGuid());
        String aOrbArtId = typeSide.getSide().isSideA() ? ".b_art_id" : ".a_art_id";
        writer.write(" AND ", new Object[0]);
        writer.write(this.relAlias1, new Object[0]);
        writer.write(aOrbArtId, new Object[0]);
        writer.write(" = ", new Object[0]);
        writer.write(this.artAlias0, new Object[0]);
        writer.write(".art_id", new Object[0]);
        writer.write(" AND ", new Object[0]);
        writer.write(this.relAlias1, new Object[0]);
        writer.write(".gamma_id = ", new Object[0]);
        writer.write(this.txsAlias1, new Object[0]);
        writer.write(".gamma_id", new Object[0]);
        writer.write(" AND ", new Object[0]);
        writer.write(writer.getTxBranchFilter(this.txsAlias1, includeDeletedRelations), new Object[0]);
        String oppositeAOrBartId = typeSide.getSide().isSideA() ? ".a_art_id" : ".b_art_id";
        writer.write("\n AND \n", new Object[0]);
        writer.write(this.relAlias1, new Object[0]);
        writer.write(oppositeAOrBartId, new Object[0]);
        writer.write(" = ", new Object[0]);
        writer.write(this.artAlias2, new Object[0]);
        writer.write(".art_id", new Object[0]);
        writer.write(" AND ", new Object[0]);
        writer.write(this.artAlias2, new Object[0]);
        writer.write(".gamma_id = ", new Object[0]);
        writer.write(this.txsAlias2, new Object[0]);
        writer.write(".gamma_id", new Object[0]);
        writer.write(" AND ", new Object[0]);
        writer.write(writer.getTxBranchFilter(this.txsAlias2, includeDeletedRelations), new Object[0]);
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.FOLLOW_RELATION_TYPES.ordinal();
    }
}

