/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelatedTo;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.AliasEntry;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlUtil;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.WithClause;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;

public class RelatedToSqlHandler
extends SqlHandler<CriteriaRelatedTo> {
    private static final AliasEntry RELATION_WITH = SqlUtil.newAlias("relatedTo", "relTo");
    private CriteriaRelatedTo criteria;
    private String jIdAlias;
    private String relAlias;
    private String txsAlias;
    private String artAlias;
    private String artTxsAlias;
    private String withClauseName;
    private WithClause withClause;

    @Override
    public void addWithTables(AbstractSqlWriter writer) {
        if (OptionsUtil.isHistorical((Options)writer.getOptions())) {
            List<String> aliases;
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT max(txs.transaction_id) as transaction_id, rel.a_art_id as art_id\n");
            sb.append("    FROM osee_txs txs, osee_relation_link rel");
            if (this.criteria.hasMultipleIds()) {
                sb.append(", ");
                sb.append(TableEnum.ID_JOIN_TABLE.getName());
                sb.append(" ");
                sb.append(this.jIdAlias);
            }
            if (!(aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE)).isEmpty()) {
                int aSize = aliases.size();
                int index = 0;
                while (index < aSize) {
                    String artAlias = aliases.get(index);
                    sb.append(", ");
                    sb.append(TableEnum.ARTIFACT_TABLE.getName());
                    sb.append(" ");
                    sb.append(artAlias);
                    ++index;
                }
            }
            sb.append("\n    WHERE  txs.gamma_id = rel.gamma_id AND \n");
            sb.append(this.getPredicate(writer, "txs", "rel"));
            sb.append(" AND ");
            sb.append(writer.getWithClauseTxBranchFilter("txs", false));
            sb.append("\n    GROUP BY rel.a_art_id\n");
            String body = sb.toString();
            this.withClauseName = writer.getNextAlias(RELATION_WITH);
            this.withClause = SqlUtil.newSimpleWithClause(this.withClauseName, body);
            writer.addWithClause(this.withClause);
            writer.addTable(this.withClauseName);
        }
    }

    @Override
    public void setData(CriteriaRelatedTo criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        if (this.criteria.hasMultipleIds()) {
            this.jIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.relAlias = writer.addTable(TableEnum.RELATION_TABLE);
        this.txsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.RELATION);
        List<String> artAliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        if (artAliases.isEmpty()) {
            this.artAlias = writer.addTable(TableEnum.ARTIFACT_TABLE);
            this.artTxsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
        }
    }

    private String getPredicate(AbstractSqlWriter writer, String txsAliasName, String relAliasName) throws OseeCoreException {
        String aOrbArtId;
        StringBuilder sb = new StringBuilder();
        RelationTypeSide typeSide = this.criteria.getType();
        sb.append(relAliasName);
        sb.append(".rel_link_type_id = ?");
        writer.addParameter(typeSide.getGuid());
        sb.append(" AND ");
        String string = aOrbArtId = typeSide.getSide().isSideA() ? ".a_art_id" : ".b_art_id";
        if (this.criteria.hasMultipleIds()) {
            IdJoinQuery joinQuery = writer.writeJoin(this.criteria.getIds());
            sb.append(relAliasName);
            sb.append(aOrbArtId);
            sb.append(" = ");
            sb.append(this.jIdAlias);
            sb.append(".id AND ");
            sb.append(this.jIdAlias);
            sb.append(".query_id = ?");
            writer.addParameter(joinQuery.getQueryId());
        } else {
            sb.append(relAliasName);
            sb.append(aOrbArtId);
            sb.append(" = ?");
            writer.addParameter(this.criteria.getId());
        }
        List<String> aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        if (!aliases.isEmpty()) {
            sb.append("\n AND \n");
            String oppositeAOrBartId = typeSide.getSide().isSideA() ? ".b_art_id" : ".a_art_id";
            int aSize = aliases.size();
            int index = 0;
            while (index < aSize) {
                String artAlias = aliases.get(index);
                sb.append(relAliasName);
                sb.append(oppositeAOrBartId);
                sb.append(" = ");
                sb.append(artAlias);
                sb.append(".art_id");
                if (index + 1 < aSize) {
                    sb.append("\n AND \n");
                }
                ++index;
            }
        }
        sb.append("\n AND \n");
        sb.append(relAliasName);
        sb.append(".gamma_id = ");
        sb.append(txsAliasName);
        sb.append(".gamma_id");
        return sb.toString();
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        if (this.artAlias != null && this.artTxsAlias != null) {
            writer.writeEquals(this.artAlias, this.artTxsAlias, "gamma_id");
            writer.write(" AND ", new Object[0]);
            writer.write(writer.getTxBranchFilter(this.artTxsAlias), new Object[0]);
            writer.writeAndLn();
        }
        writer.write(this.getPredicate(writer, this.txsAlias, this.relAlias), new Object[0]);
        if (this.withClause != null) {
            writer.writeAndLn();
            writer.write(this.txsAlias, new Object[0]);
            writer.write(".transaction_id = ", new Object[0]);
            writer.write(this.withClauseName, new Object[0]);
            writer.write(".transaction_id", new Object[0]);
        }
        writer.writeAndLn();
        boolean includeDeletedRelations = OptionsUtil.areDeletedRelationsIncluded((Options)writer.getOptions());
        writer.write(writer.getTxBranchFilter(this.txsAlias, includeDeletedRelations), new Object[0]);
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.RELATED_TO_ART_IDS.ordinal();
    }
}

