/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaMergeBranchFor;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;

public class MergeBranchForSqlHandler
extends SqlHandler<CriteriaMergeBranchFor> {
    private CriteriaMergeBranchFor criteria;
    private String brAlias;
    private String mergeAlias;

    @Override
    public void setData(CriteriaMergeBranchFor criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> mergeAliases = writer.getAliases(TableEnum.MERGE_TABLE);
        this.mergeAlias = mergeAliases.isEmpty() ? writer.addTable(TableEnum.MERGE_TABLE) : mergeAliases.iterator().next();
        List<String> branchAliases = writer.getAliases(TableEnum.BRANCH_TABLE);
        this.brAlias = branchAliases.isEmpty() ? writer.addTable(TableEnum.BRANCH_TABLE) : branchAliases.iterator().next();
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        writer.write("%s.source_branch_id = ?", this.mergeAlias);
        writer.addParameter(this.criteria.getSource());
        writer.writeAndLn();
        writer.write("%s.dest_branch_id = ?", this.mergeAlias);
        writer.addParameter(this.criteria.getDestination());
        writer.writeAndLn();
        writer.write("%s.merge_branch_id = %s.branch_id", this.mergeAlias, this.brAlias);
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.MERGE_BRANCH_FOR.ordinal();
    }
}

