/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaBranchName;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;

public class BranchNameSqlHandler
extends SqlHandler<CriteriaBranchName> {
    private CriteriaBranchName criteria;
    private String brAlias;

    @Override
    public void setData(CriteriaBranchName criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> branchAliases = writer.getAliases(TableEnum.BRANCH_TABLE);
        this.brAlias = branchAliases.isEmpty() ? writer.addTable(TableEnum.BRANCH_TABLE) : branchAliases.iterator().next();
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        String value = this.criteria.getValue();
        if (this.criteria.isPattern()) {
            writer.writePatternMatch(String.valueOf(this.brAlias) + ".branch_name", "?");
        } else {
            writer.write(this.brAlias, new Object[0]);
            writer.write(".branch_name = ?", new Object[0]);
        }
        writer.addParameter(value);
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.BRANCH_NAME.ordinal();
    }
}

