/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaBranchIds;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;

public class BranchIdsSqlHandler
extends SqlHandler<CriteriaBranchIds> {
    private CriteriaBranchIds criteria;
    private String brAlias;
    private String jIdAlias;

    @Override
    public void setData(CriteriaBranchIds criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> branchAliases;
        if (this.criteria.getIds().size() > 1) {
            this.jIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.brAlias = (branchAliases = writer.getAliases(TableEnum.BRANCH_TABLE)).isEmpty() ? writer.addTable(TableEnum.BRANCH_TABLE) : branchAliases.iterator().next();
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        Collection ids = this.criteria.getIds();
        if (ids.size() > 1) {
            IdJoinQuery joinQuery = writer.writeJoin(ids);
            writer.write(this.brAlias, new Object[0]);
            writer.write(".branch_id = ", new Object[0]);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".id AND ", new Object[0]);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".query_id = ?", new Object[0]);
            writer.addParameter(joinQuery.getQueryId());
        } else {
            writer.write(this.brAlias, new Object[0]);
            writer.write(".branch_id = ?", new Object[0]);
            writer.addParameter(ids.iterator().next());
        }
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.BRANCH_ID.ordinal();
    }
}

