/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaBranchArchived;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;

public class BranchArchivedSqlHandler
extends SqlHandler<CriteriaBranchArchived> {
    private CriteriaBranchArchived criteria;
    private String brAlias;
    private String jIdAlias;

    @Override
    public void setData(CriteriaBranchArchived criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> branchAliases;
        if (this.criteria.getStates().size() > 1) {
            this.jIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.brAlias = (branchAliases = writer.getAliases(TableEnum.BRANCH_TABLE)).isEmpty() ? writer.addTable(TableEnum.BRANCH_TABLE) : branchAliases.iterator().next();
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        Collection states = this.criteria.getStates();
        if (states.size() > 1) {
            HashSet<Integer> ids = new HashSet<Integer>();
            for (BranchArchivedState state : states) {
                ids.add(state.getValue());
            }
            IdJoinQuery joinQuery = writer.writeIdJoin(ids);
            writer.write(this.brAlias, new Object[0]);
            writer.write(".archived = ", new Object[0]);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".id AND ", new Object[0]);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".query_id = ?", new Object[0]);
            writer.addParameter(joinQuery.getQueryId());
        } else {
            writer.write(this.brAlias, new Object[0]);
            writer.write(".archived = ?", new Object[0]);
            writer.addParameter(((BranchArchivedState)states.iterator().next()).getValue());
        }
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.BRANCH_ARCHIVED.ordinal();
    }
}

