/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaBranchAncestorOf;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.AliasEntry;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlUtil;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;

public class BranchAncestorOfSqlHandler
extends SqlHandler<CriteriaBranchAncestorOf> {
    private static final AliasEntry ANCESTOR_OF_ENTRY = SqlUtil.newAlias("ancestor_of", "anstrof");
    private CriteriaBranchAncestorOf criteria;
    private String withAlias;
    private String brAlias;

    @Override
    public void setData(CriteriaBranchAncestorOf criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addWithTables(AbstractSqlWriter writer) {
        this.withAlias = writer.getNextAlias(ANCESTOR_OF_ENTRY);
        StringBuilder body = new StringBuilder();
        body.append("  SELECT anch_br1.parent_branch_id, 0 as branch_level FROM osee_branch anch_br1\n");
        body.append("   WHERE anch_br1.branch_id = ?");
        body.append("\n  UNION ALL \n");
        body.append("  SELECT parent_branch_id, branch_level - 1 FROM ").append(this.withAlias);
        body.append(" recurse, osee_branch br");
        body.append(" WHERE br.branch_id = recurse.parent_id");
        writer.addParameter(this.criteria.getChild());
        writer.addWithClause(SqlUtil.newRecursiveWithClause(this.withAlias, "(parent_id, branch_level)", body.toString()));
        writer.addTable(this.withAlias);
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> branchAliases = writer.getAliases(TableEnum.BRANCH_TABLE);
        this.brAlias = branchAliases.isEmpty() ? writer.addTable(TableEnum.BRANCH_TABLE) : branchAliases.iterator().next();
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        writer.write("%s.branch_id = %s.parent_id", this.brAlias, this.withAlias);
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.BRANCH_ANCESTOR_OF.ordinal();
    }
}

