/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeTypeNotExists;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class AttributeTypeNotExistsSqlHandler
extends SqlHandler<CriteriaAttributeTypeNotExists> {
    private CriteriaAttributeTypeNotExists criteria;
    private String jIdAlias;
    private String artAlias;
    private String txsAlias;
    private AbstractJoinQuery joinQuery;

    @Override
    public void setData(CriteriaAttributeTypeNotExists criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        if (this.criteria.getTypes().size() > 1) {
            this.jIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.artAlias = writer.getOrCreateTableAlias(TableEnum.ARTIFACT_TABLE);
        this.txsAlias = writer.getOrCreateTableAlias(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        Collection types = this.criteria.getTypes();
        writer.writeEquals(this.artAlias, this.txsAlias, "gamma_id");
        writer.writeAndLn();
        writer.write(writer.getTxBranchFilter(this.txsAlias), new Object[0]);
        writer.writeAndLn();
        writer.write("NOT EXISTS (SELECT 1 FROM ", new Object[0]);
        writer.write(TableEnum.ATTRIBUTE_TABLE.getName(), new Object[0]);
        writer.write(" attr, ", new Object[0]);
        writer.write(TableEnum.TXS_TABLE.getName(), new Object[0]);
        writer.write(" txs WHERE ", new Object[0]);
        if (types.size() > 1) {
            HashSet<AttributeTypeId> typeIds = new HashSet<AttributeTypeId>();
            for (AttributeTypeId type : types) {
                typeIds.add(type);
            }
            this.joinQuery = writer.writeJoin(typeIds);
            writer.write("attr.attr_type_id = ", new Object[0]);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".id AND ", new Object[0]);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".query_id = ?", new Object[0]);
            writer.addParameter(this.joinQuery.getQueryId());
        } else {
            AttributeTypeId type = (AttributeTypeId)types.iterator().next();
            writer.write("attr.attr_type_id = ?", new Object[0]);
            writer.addParameter(type);
        }
        writer.writeAndLn();
        writer.writeEquals("attr", "txs", "gamma_id");
        writer.writeAndLn();
        writer.write(writer.getTxBranchFilter("txs"), new Object[0]);
        writer.writeAndLn();
        writer.writeEquals("attr", this.artAlias, "art_id");
        writer.write(")", new Object[0]);
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ATTRIBUTE_TYPE_NOT_EXISTS.ordinal();
    }
}

