/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeTypeExists;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.AliasEntry;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlUtil;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.WithClause;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;

public class AttributeTypeExistsSqlHandler
extends SqlHandler<CriteriaAttributeTypeExists> {
    private static final AliasEntry ATTRIBUTE_EXIST_WITH = SqlUtil.newAlias("attr_exists", "attrExt");
    private CriteriaAttributeTypeExists criteria;
    private String artAlias;
    private String artTxsAlias;
    private String attrAlias;
    private String txsAlias;
    private String jIdAlias;
    private AbstractJoinQuery joinQuery;
    private String withClauseName;
    private WithClause withClause;

    @Override
    public void setData(CriteriaAttributeTypeExists criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addWithTables(AbstractSqlWriter writer) {
        if (OptionsUtil.isHistorical((Options)writer.getOptions())) {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT max(txs.transaction_id) as transaction_id, attr.art_id as art_id\n");
            Collection types = this.criteria.getTypes();
            if (types.size() > 1) {
                sb.append("    FROM osee_txs txs, osee_attribute attr, osee_join_id id\n");
            } else {
                sb.append("    FROM osee_txs txs, osee_attribute attr\n");
            }
            sb.append("    WHERE txs.gamma_id = attr.gamma_id\n");
            if (types.size() > 1) {
                IdJoinQuery joinQuery = writer.writeJoin(types);
                sb.append("   AND attr.attr_type_id = id.id AND id.query_id = ?");
                writer.addParameter(joinQuery.getQueryId());
            } else {
                sb.append("    AND att.attr_type_id = ?");
                writer.addParameter(types.iterator().next());
            }
            sb.append(" AND ");
            sb.append(writer.getWithClauseTxBranchFilter("txs", false));
            sb.append("\n    GROUP BY attr.art_id");
            String body = sb.toString();
            this.withClauseName = writer.getNextAlias(ATTRIBUTE_EXIST_WITH);
            this.withClause = SqlUtil.newSimpleWithClause(this.withClauseName, body);
            writer.addWithClause(this.withClause);
            writer.addTable(this.withClauseName);
        }
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> artAliases;
        if (this.criteria.getTypes().size() > 1) {
            this.jIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        if ((artAliases = writer.getAliases(TableEnum.ARTIFACT_TABLE)).isEmpty()) {
            this.artAlias = writer.addTable(TableEnum.ARTIFACT_TABLE);
            this.artTxsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
        }
        this.attrAlias = writer.addTable(TableEnum.ATTRIBUTE_TABLE);
        this.txsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ATTRIBUTE);
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        Collection types;
        if (this.artAlias != null && this.artTxsAlias != null) {
            writer.writeEquals(this.artAlias, this.artTxsAlias, "gamma_id");
            writer.write(" AND ", new Object[0]);
            writer.write(writer.getTxBranchFilter(this.artTxsAlias), new Object[0]);
            writer.writeAndLn();
        }
        if ((types = this.criteria.getTypes()).size() > 1) {
            this.joinQuery = writer.writeJoin(types);
            writer.write(this.attrAlias, new Object[0]);
            writer.write(".attr_type_id = ", new Object[0]);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".id AND ", new Object[0]);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".query_id = ?", new Object[0]);
            writer.addParameter(this.joinQuery.getQueryId());
        } else {
            AttributeTypeId type = (AttributeTypeId)types.iterator().next();
            writer.write(this.attrAlias, new Object[0]);
            writer.write(".attr_type_id = ?", new Object[0]);
            writer.addParameter(type);
        }
        List<String> aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        if (!aliases.isEmpty()) {
            writer.writeAndLn();
            int aSize = aliases.size();
            int index = 0;
            while (index < aSize) {
                String artAlias = aliases.get(index);
                writer.write(this.attrAlias, new Object[0]);
                writer.write(".art_id = ", new Object[0]);
                writer.write(artAlias, new Object[0]);
                writer.write(".art_id", new Object[0]);
                if (index + 1 < aSize) {
                    writer.write(" AND ", new Object[0]);
                }
                ++index;
            }
        }
        if (this.withClause != null) {
            writer.writeAndLn();
            writer.write(this.withClauseName, new Object[0]);
            writer.write(".transaction_id = ", new Object[0]);
            writer.write(this.txsAlias, new Object[0]);
            writer.write(".transaction_id AND ", new Object[0]);
            writer.write(this.withClauseName, new Object[0]);
            writer.write(".art_id = ", new Object[0]);
            writer.write(this.attrAlias, new Object[0]);
            writer.write(".art_id", new Object[0]);
        }
        writer.writeAndLn();
        writer.write(this.attrAlias, new Object[0]);
        writer.write(".gamma_id = ", new Object[0]);
        writer.write(this.txsAlias, new Object[0]);
        writer.write(".gamma_id AND ", new Object[0]);
        boolean includeDeletedAttributes = OptionsUtil.areDeletedAttributesIncluded((Options)writer.getOptions());
        writer.write(writer.getTxBranchFilter(this.txsAlias, includeDeletedAttributes), new Object[0]);
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ATTRIBUTE_TYPE_EXISTS.ordinal();
    }
}

