/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeKeywords;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.search.tagger.HasTagProcessor;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagCollector;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagProcessor;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.AliasEntry;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlUtil;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;

public class AttributeTokenSqlHandler
extends SqlHandler<CriteriaAttributeKeywords>
implements HasTagProcessor {
    private static final AliasEntry GAMMA_WITH = SqlUtil.newAlias("gamma", "gamma");
    private static final AliasEntry ATTRIBUTE_WITH = SqlUtil.newAlias("attribute", "att");
    private CriteriaAttributeKeywords criteria;
    private String artAlias;
    private String attrAlias;
    private String txsAlias;
    private TagProcessor tagProcessor;

    @Override
    public void setTagProcessor(TagProcessor tagProcessor) {
        this.tagProcessor = tagProcessor;
    }

    @Override
    public TagProcessor getTagProcessor() {
        return this.tagProcessor;
    }

    @Override
    public void setData(CriteriaAttributeKeywords criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addWithTables(AbstractSqlWriter writer) throws OseeCoreException {
        String gammaAlias = writer.getNextAlias(GAMMA_WITH);
        StringBuilder gammaSb = new StringBuilder();
        Collection types = this.criteria.getTypes();
        IdJoinQuery joinQuery = null;
        String jIdAlias = null;
        if (!this.criteria.isIncludeAllTypes() && types.size() > 1) {
            HashSet<AttributeTypeId> typeIds = new HashSet<AttributeTypeId>();
            for (AttributeTypeId type : types) {
                typeIds.add(type);
            }
            jIdAlias = writer.getNextAlias(TableEnum.ID_JOIN_TABLE);
            joinQuery = writer.writeJoin(typeIds);
        }
        Collection values = this.criteria.getValues();
        int valueCount = values.size();
        int valueIdx = 0;
        for (String value : values) {
            block15: {
                int tagsSize;
                ArrayList<Long> tags;
                block14: {
                    block16: {
                        tags = new ArrayList<Long>();
                        this.tokenize(value, tags);
                        tagsSize = tags.size();
                        gammaSb.append("  ( \n");
                        if (tagsSize != 0) break block14;
                        gammaSb.append("    SELECT gamma_id FROM osee_attribute");
                        if (Strings.isValid((String)jIdAlias)) {
                            gammaSb.append(", osee_join_id ");
                            gammaSb.append(jIdAlias);
                        }
                        gammaSb.append(" where value ");
                        if (!Strings.isValid((String)value)) {
                            gammaSb.append("is null or value = ''");
                        } else {
                            gammaSb.append("= ?");
                            writer.addParameter(value);
                        }
                        if (this.criteria.isIncludeAllTypes()) break block15;
                        gammaSb.append(" AND attr_type_id = ");
                        if (types.size() != 1) break block16;
                        gammaSb.append("?");
                        writer.addParameter(types.iterator().next());
                        break block15;
                    }
                    gammaSb.append(jIdAlias);
                    gammaSb.append(".id AND ");
                    gammaSb.append(jIdAlias);
                    gammaSb.append(".query_id = ?");
                    if (joinQuery == null) break block15;
                    writer.addParameter(joinQuery.getQueryId());
                    break block15;
                }
                int tagIdx = 0;
                while (tagIdx < tagsSize) {
                    Long tag = (Long)tags.get(tagIdx);
                    gammaSb.append("    SELECT gamma_id FROM osee_search_tags WHERE coded_tag_id = ?");
                    writer.addParameter(tag);
                    if (tagIdx + 1 < tagsSize) {
                        gammaSb.append("\n INTERSECT \n");
                    }
                    ++tagIdx;
                }
            }
            gammaSb.append("\n  ) ");
            if (valueIdx + 1 < valueCount) {
                gammaSb.append("\n UNION ALL \n");
            }
            ++valueIdx;
        }
        writer.addWithClause(SqlUtil.newSimpleWithClause(gammaAlias, gammaSb.toString()));
        this.attrAlias = writer.getNextAlias(ATTRIBUTE_WITH);
        StringBuilder attrSb = new StringBuilder();
        attrSb.append("   SELECT art_id FROM osee_attribute att, osee_txs txs, ");
        if (!this.criteria.isIncludeAllTypes() && types.size() > 1) {
            attrSb.append("osee_join_id ");
            attrSb.append(jIdAlias);
            attrSb.append(", ");
        }
        attrSb.append(gammaAlias);
        attrSb.append("\n WHERE \n");
        attrSb.append("   att.gamma_id = ");
        attrSb.append(gammaAlias);
        attrSb.append(".gamma_id");
        if (!this.criteria.isIncludeAllTypes()) {
            attrSb.append(" AND att.attr_type_id = ");
            if (types.size() == 1) {
                attrSb.append("?");
                writer.addParameter(this.criteria.getTypes().iterator().next());
            } else {
                attrSb.append(jIdAlias);
                attrSb.append(".id AND ");
                attrSb.append(jIdAlias);
                attrSb.append(".query_id = ?");
                if (joinQuery != null) {
                    writer.addParameter(joinQuery.getQueryId());
                }
            }
        }
        attrSb.append("\n AND \n");
        attrSb.append("   att.gamma_id = txs.gamma_id");
        attrSb.append(" AND ");
        attrSb.append(writer.getWithClauseTxBranchFilter("txs", true));
        writer.addWithClause(SqlUtil.newSimpleWithClause(this.attrAlias, attrSb.toString()));
        writer.addTable(this.attrAlias);
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        List<String> txs = writer.getAliases(TableEnum.TXS_TABLE);
        if (aliases.isEmpty()) {
            this.artAlias = writer.addTable(TableEnum.ARTIFACT_TABLE);
        }
        if (txs.isEmpty()) {
            this.txsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
        }
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        boolean artTableAdded = false;
        boolean txsTableAdded = false;
        if (!Strings.isValid((String)this.artAlias)) {
            this.artAlias = writer.getAliases(TableEnum.ARTIFACT_TABLE).iterator().next();
        } else {
            artTableAdded = true;
        }
        if (!Strings.isValid((String)this.txsAlias)) {
            this.txsAlias = writer.getAliases(TableEnum.TXS_TABLE).iterator().next();
        } else {
            txsTableAdded = true;
        }
        writer.write("%s.art_id = %s.art_id", this.artAlias, this.attrAlias);
        if (artTableAdded) {
            writer.writeAndLn();
            writer.write("%s.gamma_id = %s.gamma_id", this.txsAlias, this.artAlias);
        }
        if (txsTableAdded) {
            writer.writeAndLn();
            writer.write(writer.getTxBranchFilter(this.txsAlias), new Object[0]);
        }
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ATTRIBUTE_TOKENIZED_VALUE.ordinal();
    }

    private void tokenize(String value, final Collection<Long> codedTags) {
        TagCollector collector = new TagCollector(){

            @Override
            public void addTag(String word, Long codedTag) {
                codedTags.add(codedTag);
            }
        };
        this.getTagProcessor().collectFromString(value, collector);
    }
}

