/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeOther;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class AttributeOtherSqlHandler
extends SqlHandler<CriteriaAttributeOther> {
    private CriteriaAttributeOther criteria;
    private String attrAlias;
    private String txsAlias1;
    private String artAlias2;
    private String txs2Alias2;
    private String valueJoinAlias;
    private AbstractJoinQuery valueJoinQuery;
    private String typeJoinAlias;
    private AbstractJoinQuery typeJoinQuery;
    private Collection<String> values;
    private boolean ignoreCase;
    private Collection<AttributeTypeId> types;

    @Override
    public void setData(CriteriaAttributeOther criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.values = this.getValuesForSearch();
        if (this.values.size() > 1) {
            this.valueJoinQuery = writer.writeCharJoin(this.values);
            this.valueJoinAlias = writer.addTable(TableEnum.CHAR_JOIN_TABLE);
        }
        this.types = this.criteria.getAttributeTypes();
        if (this.types.size() > 1) {
            this.typeJoinQuery = writer.writeJoin(this.types);
            this.typeJoinAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        List<String> aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        List<String> txs = writer.getAliases(TableEnum.TXS_TABLE);
        this.attrAlias = writer.addTable(TableEnum.ATTRIBUTE_TABLE);
        this.txsAlias1 = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ATTRIBUTE);
        if (aliases.isEmpty()) {
            this.artAlias2 = writer.addTable(TableEnum.ARTIFACT_TABLE);
        }
        if (txs.isEmpty()) {
            this.txs2Alias2 = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
        }
    }

    private Collection<String> getValuesForSearch() {
        List copy = Lists.newArrayList((Iterable)this.criteria.getValues());
        this.ignoreCase = this.criteria.getOptions().contains(QueryOption.CASE__IGNORE);
        if (this.ignoreCase) {
            copy = Lists.transform((List)copy, (Function)new Function<String, String>(){

                public String apply(String arg0) {
                    return arg0.toLowerCase();
                }
            });
        }
        return copy;
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        List<String> aliases;
        Collection attributeTypes = this.criteria.getAttributeTypes();
        if (attributeTypes.size() == 1) {
            writer.write(this.attrAlias, new Object[0]);
            writer.write(".attr_type_id = ?", new Object[0]);
            writer.addParameter(attributeTypes.iterator().next());
        } else if (attributeTypes.size() > 1) {
            writer.write(this.attrAlias, new Object[0]);
            writer.write(".attr_type_id = ", new Object[0]);
            writer.write(this.typeJoinAlias, new Object[0]);
            writer.write(".id", new Object[0]);
            writer.write(" AND ", new Object[0]);
            writer.write(this.typeJoinAlias, new Object[0]);
            writer.write(".query_id = ?", new Object[0]);
            writer.addParameter(this.typeJoinQuery.getQueryId());
        }
        if (this.values.size() == 1) {
            String value = this.values.iterator().next();
            writer.write(" AND ", new Object[0]);
            if (this.ignoreCase) {
                writer.write("lower(", new Object[0]);
            }
            writer.write(this.attrAlias, new Object[0]);
            writer.write(".value", new Object[0]);
            String ending = this.ignoreCase ? ") " : " ";
            writer.write(ending, new Object[0]);
            if (value.contains("%")) {
                writer.write(" LIKE ", new Object[0]);
            } else {
                writer.write("=", new Object[0]);
            }
            writer.write(" ?", new Object[0]);
            writer.addParameter(value);
        }
        if (this.valueJoinQuery != null) {
            writer.write(" AND ", new Object[0]);
            if (this.ignoreCase) {
                writer.write("lower(", new Object[0]);
            }
            writer.write(this.attrAlias, new Object[0]);
            writer.write(".value", new Object[0]);
            String ending = this.ignoreCase ? ") = " : " = ";
            writer.write(ending, new Object[0]);
            writer.write(this.valueJoinAlias, new Object[0]);
            writer.write(".id AND ", new Object[0]);
            writer.write(this.valueJoinAlias, new Object[0]);
            writer.write(".query_id = ?", new Object[0]);
            writer.addParameter(this.valueJoinQuery.getQueryId());
        }
        if (!(aliases = writer.getAliases(TableEnum.ARTIFACT_TABLE)).isEmpty()) {
            writer.writeAndLn();
            int aSize = aliases.size();
            int index = 0;
            while (index < aSize) {
                String artAlias = aliases.get(index);
                writer.write(artAlias, new Object[0]);
                writer.write(".art_id = ", new Object[0]);
                writer.write(this.attrAlias, new Object[0]);
                writer.write(".art_id", new Object[0]);
                if (index + 1 < aSize) {
                    writer.write(" AND ", new Object[0]);
                }
                ++index;
            }
        }
        writer.write(" AND ", new Object[0]);
        writer.write(this.attrAlias, new Object[0]);
        writer.write(".gamma_id = ", new Object[0]);
        writer.write(this.txsAlias1, new Object[0]);
        writer.write(".gamma_id AND ", new Object[0]);
        writer.write(writer.getTxBranchFilter(this.txsAlias1), new Object[0]);
        if (this.txs2Alias2 != null && this.artAlias2 != null) {
            writer.writeAndLn();
            writer.write(this.artAlias2, new Object[0]);
            writer.write(".gamma_id = ", new Object[0]);
            writer.write(this.txs2Alias2, new Object[0]);
            writer.write(".gamma_id AND ", new Object[0]);
            writer.write(writer.getTxBranchFilter(this.txs2Alias2), new Object[0]);
        }
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ATTRIBUTE_VALUE.ordinal();
    }
}

