/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaArtifactType;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class ArtifactTypeSqlHandler
extends SqlHandler<CriteriaArtifactType> {
    private CriteriaArtifactType criteria;
    private String jIdAlias;
    private String artAlias;
    private String txsAlias;
    private AbstractJoinQuery joinQuery;
    private List<String> artAliases;
    private List<String> txsAliases;
    private boolean artAliasCreated;
    private boolean txsAliasCreated;

    @Override
    public void setData(CriteriaArtifactType criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) throws OseeCoreException {
        Collection types = this.criteria.getTypes();
        if (types.size() > 1) {
            this.jIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.artAliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        this.txsAliases = writer.getAliases(TableEnum.TXS_TABLE);
        if (this.artAliases.isEmpty()) {
            this.artAlias = writer.addTable(TableEnum.ARTIFACT_TABLE);
            this.artAliasCreated = true;
        }
        if (this.txsAliases.isEmpty()) {
            this.txsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
            this.txsAliasCreated = true;
        }
        this.artAliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        this.txsAliases = writer.getAliases(TableEnum.TXS_TABLE);
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        Collection types = this.criteria.getTypes();
        if (types.size() > 1) {
            this.joinQuery = writer.writeJoin(types);
            writer.write(this.jIdAlias, new Object[0]);
            writer.write(".query_id = ?", new Object[0]);
            writer.addParameter(this.joinQuery.getQueryId());
            if (!this.artAliases.isEmpty()) {
                writer.write(" AND ", new Object[0]);
                int aSize = this.artAliases.size();
                int index = 0;
                while (index < aSize) {
                    String artAlias = this.artAliases.get(index);
                    writer.write(artAlias, new Object[0]);
                    writer.write(".art_type_id = ", new Object[0]);
                    writer.write(this.jIdAlias, new Object[0]);
                    writer.write(".id", new Object[0]);
                    if (index + 1 < aSize) {
                        writer.write(" AND ", new Object[0]);
                    }
                    ++index;
                }
            }
        } else {
            ArtifactTypeId artifactType = (ArtifactTypeId)types.iterator().next();
            int aSize = this.artAliases.size();
            int index = 0;
            while (index < aSize) {
                String artAlias = this.artAliases.get(index);
                writer.write(artAlias, new Object[0]);
                writer.write(".art_type_id = ?", new Object[0]);
                writer.addParameter(artifactType);
                if (index + 1 < aSize) {
                    writer.write(" AND ", new Object[0]);
                }
                ++index;
            }
        }
        if (this.artAliasCreated && this.txsAliasCreated) {
            writer.write(" AND ", new Object[0]);
            writer.write(this.artAlias, new Object[0]);
            writer.write(".gamma_id = ", new Object[0]);
            writer.write(this.txsAlias, new Object[0]);
            writer.write(".gamma_id AND ", new Object[0]);
            writer.write(writer.getTxBranchFilter(this.txsAlias), new Object[0]);
        }
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ARTIFACT_TYPE.ordinal();
    }
}

