/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaArtifactIds;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.AliasEntry;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlUtil;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.WithClause;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;

public class ArtifactIdsSqlHandler
extends SqlHandler<CriteriaArtifactIds> {
    private static final AliasEntry ART_ID_WITH = SqlUtil.newAlias("historicalArtifactIdWith", "artIdHist");
    private CriteriaArtifactIds criteria;
    private String artAlias;
    private String jIdAlias;
    private String txsAlias;
    private String withClauseName;
    private WithClause withClause;

    @Override
    public void addWithTables(AbstractSqlWriter writer) {
        if (OptionsUtil.isHistorical((Options)writer.getOptions())) {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT max(txs.transaction_id) as transaction_id, art.art_id\n    FROM osee_txs txs, osee_artifact art");
            if (this.criteria.hasMultipleIds()) {
                sb.append(", osee_join_id id");
            }
            sb.append("\n    WHERE txs.gamma_id = art.gamma_id\n");
            if (this.criteria.hasMultipleIds()) {
                IdJoinQuery joinQuery = writer.writeJoin(this.criteria.getIds());
                sb.append("    AND art.art_id = id.id AND id.query_id = ?");
                writer.addParameter(joinQuery.getQueryId());
            } else {
                sb.append("    AND art.art_id = ?");
                writer.addParameter(this.criteria.getId());
            }
            sb.append(" AND ");
            sb.append(writer.getWithClauseTxBranchFilter("txs", false));
            sb.append("\n    GROUP BY art.art_id");
            String body = sb.toString();
            this.withClauseName = writer.getNextAlias(ART_ID_WITH);
            this.withClause = SqlUtil.newSimpleWithClause(this.withClauseName, body);
            writer.addWithClause(this.withClause);
            writer.addTable(this.withClauseName);
        }
    }

    @Override
    public void setData(CriteriaArtifactIds criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        if (this.criteria.hasMultipleIds() && !OptionsUtil.isHistorical((Options)writer.getOptions())) {
            this.jIdAlias = writer.addTable(TableEnum.ID_JOIN_TABLE);
        }
        this.artAlias = writer.addTable(TableEnum.ARTIFACT_TABLE);
        this.txsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        if (OptionsUtil.isHistorical((Options)writer.getOptions())) {
            writer.write(this.withClauseName, new Object[0]);
            writer.write(".transaction_id = ", new Object[0]);
            writer.write(this.txsAlias, new Object[0]);
            writer.write(".transaction_id AND ", new Object[0]);
            writer.write(this.withClauseName, new Object[0]);
            writer.write(".art_id = ", new Object[0]);
            writer.write(this.artAlias, new Object[0]);
            writer.write(".art_id", new Object[0]);
        } else {
            writer.write(this.artAlias, new Object[0]);
            if (this.criteria.hasMultipleIds()) {
                IdJoinQuery joinQuery = writer.writeJoin(this.criteria.getIds());
                writer.write(".art_id = ", new Object[0]);
                writer.write(this.jIdAlias, new Object[0]);
                writer.write(".id AND ", new Object[0]);
                writer.write(this.jIdAlias, new Object[0]);
                writer.write(".query_id = ?", new Object[0]);
                writer.addParameter(joinQuery.getQueryId());
            } else {
                writer.write(".art_id = ?", new Object[0]);
                writer.addParameter(this.criteria.getId());
            }
        }
        writer.write(" AND ", new Object[0]);
        writer.write(this.artAlias, new Object[0]);
        writer.write(".gamma_id = ", new Object[0]);
        writer.write(this.txsAlias, new Object[0]);
        writer.write(".gamma_id AND ", new Object[0]);
        writer.write(writer.getTxBranchFilter(this.txsAlias), new Object[0]);
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ARTIFACT_ID.ordinal();
    }
}

