/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.Collection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaArtifactGuids;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.AliasEntry;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlUtil;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.WithClause;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.CharJoinQuery;

public class ArtifactGuidSqlHandler
extends SqlHandler<CriteriaArtifactGuids> {
    private static final AliasEntry ART_GUID_WITH = SqlUtil.newAlias("artifactGuidWith", "artUuid");
    private CriteriaArtifactGuids criteria;
    private String artAlias;
    private String jguidAlias;
    private String txsAlias;
    private AbstractJoinQuery joinQuery;
    private String withClauseName;
    private WithClause withClause;

    @Override
    public void addWithTables(AbstractSqlWriter writer) {
        if (OptionsUtil.isHistorical((Options)writer.getOptions())) {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT max(txs.transaction_id) as transaction_id, art.art_id as art_id\n");
            Collection ids = this.criteria.getIds();
            if (ids.size() > 1) {
                sb.append("    FROM osee_txs txs, osee_artifact art, osee_join_char_id id\n");
            } else {
                sb.append("    FROM osee_txs txs, osee_artifact art\n");
            }
            sb.append("    WHERE txs.gamma_id = art.gamma_id\n");
            if (ids.size() > 1) {
                CharJoinQuery joinQuery = writer.writeCharJoin(ids);
                sb.append("    AND art.guid = id.id AND id.query_id = ?");
                writer.addParameter(joinQuery.getQueryId());
            } else {
                sb.append("    AND art.guid = ?");
                writer.addParameter(ids.iterator().next());
            }
            sb.append(" AND ");
            sb.append(writer.getWithClauseTxBranchFilter("txs", false));
            sb.append("\n    GROUP BY art.art_id");
            String body = sb.toString();
            this.withClauseName = writer.getNextAlias(ART_GUID_WITH);
            this.withClause = SqlUtil.newSimpleWithClause(this.withClauseName, body);
            writer.addWithClause(this.withClause);
            writer.addTable(this.withClauseName);
        }
    }

    @Override
    public void setData(CriteriaArtifactGuids criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        if (this.criteria.getIds().size() > 1) {
            this.jguidAlias = writer.addTable(TableEnum.CHAR_JOIN_TABLE);
        }
        this.artAlias = writer.addTable(TableEnum.ARTIFACT_TABLE);
        this.txsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        Collection ids = this.criteria.getIds();
        if (ids.size() > 1) {
            this.joinQuery = writer.writeCharJoin(ids);
            writer.write(this.artAlias, new Object[0]);
            writer.write(".guid = ", new Object[0]);
            writer.write(this.jguidAlias, new Object[0]);
            writer.write(".id AND ", new Object[0]);
            writer.write(this.jguidAlias, new Object[0]);
            writer.write(".query_id = ?", new Object[0]);
            writer.addParameter(this.joinQuery.getQueryId());
        } else {
            writer.write(this.artAlias, new Object[0]);
            writer.write(".guid = ?", new Object[0]);
            writer.addParameter(ids.iterator().next());
        }
        if (this.withClause != null) {
            writer.writeAndLn();
            writer.write(this.withClauseName, new Object[0]);
            writer.write(".transaction_id = ", new Object[0]);
            writer.write(this.txsAlias, new Object[0]);
            writer.write(".transaction_id AND ", new Object[0]);
            writer.write(this.withClauseName, new Object[0]);
            writer.write(".art_id = ", new Object[0]);
            writer.write(this.artAlias, new Object[0]);
            writer.write(".art_id", new Object[0]);
        }
        writer.write(" AND ", new Object[0]);
        writer.write(this.artAlias, new Object[0]);
        writer.write(".gamma_id = ", new Object[0]);
        writer.write(this.txsAlias, new Object[0]);
        writer.write(".gamma_id AND ", new Object[0]);
        boolean includeDeletedArtifacts = OptionsUtil.areDeletedArtifactsIncluded((Options)writer.getOptions());
        writer.write(writer.getTxBranchFilter(this.txsAlias, includeDeletedArtifacts), new Object[0]);
        return true;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ARTIFACT_GUID.ordinal();
    }
}

