/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAllArtifacts;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;

public class AllArtifactsSqlHandler
extends SqlHandler<CriteriaAllArtifacts> {
    private String artAlias;
    private String txsAlias;

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> artAliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        List<String> txsAliases = writer.getAliases(TableEnum.TXS_TABLE);
        if (artAliases.isEmpty()) {
            this.artAlias = writer.addTable(TableEnum.ARTIFACT_TABLE);
        }
        if (txsAliases.isEmpty()) {
            this.txsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
        }
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        boolean modified = false;
        if (this.artAlias != null && this.txsAlias != null) {
            writer.write(this.artAlias, new Object[0]);
            writer.write(".gamma_id = ", new Object[0]);
            writer.write(this.txsAlias, new Object[0]);
            writer.write(".gamma_id AND ", new Object[0]);
            writer.write(writer.getTxBranchFilter(this.txsAlias), new Object[0]);
            modified = true;
        }
        return modified;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ALL_ARTIFACTS.ordinal();
    }
}

