/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;

public abstract class AbstractRelationSqlHandler<T extends Criteria>
extends SqlHandler<T> {
    protected T criteria;
    private String artAlias;
    private String artTxsAlias;

    @Override
    public void setData(T criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> artAliases = writer.getAliases(TableEnum.ARTIFACT_TABLE);
        if (artAliases.isEmpty()) {
            this.artAlias = writer.addTable(TableEnum.ARTIFACT_TABLE);
            this.artTxsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
        }
    }

    @Override
    public boolean addPredicates(AbstractSqlWriter writer) throws OseeCoreException {
        boolean modified = false;
        if (this.artAlias != null && this.artTxsAlias != null) {
            writer.writeEquals(this.artAlias, this.artTxsAlias, "gamma_id");
            writer.write(" AND ", new Object[0]);
            writer.write(writer.getTxBranchFilter(this.artTxsAlias), new Object[0]);
            writer.writeAndLn();
            modified = true;
        }
        return modified;
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.RELATION_TYPE_EXISTS.ordinal();
    }
}

