/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.QueryType;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class QuerySqlWriter
extends AbstractSqlWriter {
    private final TableEnum table;
    private final String idColumn;

    public QuerySqlWriter(Log logger, SqlJoinFactory joinFactory, JdbcClient jdbcClient, SqlContext context, QueryType queryType, TableEnum table, String idColumn) {
        super(logger, joinFactory, jdbcClient, context, queryType);
        this.table = table;
        this.idColumn = idColumn;
    }

    @Override
    public void writeSelect(Iterable<SqlHandler<?>> handlers) throws OseeCoreException {
        String tableAlias = this.getLastAlias(this.table);
        if (this.isCountQueryType()) {
            this.write("SELECT%s count(%s.%s)", this.getSqlHint(), tableAlias, this.idColumn);
        } else {
            this.write("SELECT%s %s.*", this.getSqlHint(), tableAlias);
        }
    }

    @Override
    public void writeGroupAndOrder() throws OseeCoreException {
        if (!this.isCountQueryType()) {
            String tableAlias = this.getLastAlias(this.table);
            this.write("\n ORDER BY %s.%s", tableAlias, this.idColumn);
        }
    }

    @Override
    public String getTxBranchFilter(String txsAlias) {
        return Strings.emptyString();
    }

    @Override
    public String getTxBranchFilter(String txsAlias, boolean allowDeleted) throws OseeCoreException {
        return Strings.emptyString();
    }

    @Override
    public String getWithClauseTxBranchFilter(String txsAlias, boolean deletedPredicate) throws OseeCoreException {
        return Strings.emptyString();
    }
}

