/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.db.internal.search.QueryCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.TupleQueryImpl;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.TupleQuery;

public class QueryEngineImpl
implements QueryEngine {
    private final QueryCallableFactory artifactQueryEngineFactory;
    private final QueryCallableFactory branchQueryEngineFactory;
    private final QueryCallableFactory txQueryEngineFactory;
    private final QueryCallableFactory allQueryEngineFactory;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory sqlJoinFactory;

    public QueryEngineImpl(QueryCallableFactory artifactQueryEngineFactory, QueryCallableFactory branchQueryEngineFactory, QueryCallableFactory txQueryEngineFactory, QueryCallableFactory allQueryEngineFactory, JdbcClient jdbcClient, SqlJoinFactory sqlJoinFactory) {
        this.artifactQueryEngineFactory = artifactQueryEngineFactory;
        this.branchQueryEngineFactory = branchQueryEngineFactory;
        this.txQueryEngineFactory = txQueryEngineFactory;
        this.allQueryEngineFactory = allQueryEngineFactory;
        this.jdbcClient = jdbcClient;
        this.sqlJoinFactory = sqlJoinFactory;
    }

    public CancellableCallable<Integer> createArtifactCount(OrcsSession session, QueryData queryData) {
        return this.artifactQueryEngineFactory.createCount(session, queryData);
    }

    public CancellableCallable<Integer> createArtifactQuery(OrcsSession session, QueryData queryData, LoadDataHandler handler) {
        return this.artifactQueryEngineFactory.createQuery(session, queryData, handler);
    }

    public CancellableCallable<Integer> createBranchCount(OrcsSession session, QueryData queryData) {
        return this.branchQueryEngineFactory.createCount(session, queryData);
    }

    public CancellableCallable<Integer> createBranchQuery(OrcsSession session, QueryData queryData, LoadDataHandler handler) {
        return this.branchQueryEngineFactory.createQuery(session, queryData, handler);
    }

    public CancellableCallable<Integer> createTxCount(OrcsSession session, QueryData queryData) {
        return this.txQueryEngineFactory.createCount(session, queryData);
    }

    public CancellableCallable<Integer> createTxQuery(OrcsSession session, QueryData queryData, LoadDataHandler handler) {
        return this.txQueryEngineFactory.createQuery(session, queryData, handler);
    }

    public CancellableCallable<Integer> createQuery(OrcsSession session, QueryData queryData, LoadDataHandler handler) {
        return this.allQueryEngineFactory.createQuery(session, queryData, handler);
    }

    public CancellableCallable<Integer> createQueryCount(OrcsSession session, QueryData queryData) {
        return this.allQueryEngineFactory.createCount(session, queryData);
    }

    public TupleQuery createTupleQuery() {
        return new TupleQueryImpl(this.jdbcClient, this.sqlJoinFactory);
    }
}

