/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.framework.jdk.core.type.MutableBoolean;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.DynamicData;
import org.eclipse.osee.orcs.core.ds.DynamicObject;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.ResultObjectDescription;
import org.eclipse.osee.orcs.db.internal.search.handlers.AbstractXtraTableSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.search.handlers.XtraAttributeDataSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.XtraBranchDataSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.XtraRelationDataSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.XtraTxDataSqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.ObjectField;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.QueryType;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlFieldResolver;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerComparator;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class ObjectQuerySqlWriter
extends AbstractSqlWriter {
    private static final SqlHandlerComparator HANDLER_COMPARATOR = new SqlHandlerComparator();
    private final Log logger;
    private final SqlFieldResolver fieldResolver;
    private WithClauseTxFilterData withTxFilterClause;

    public ObjectQuerySqlWriter(Log logger, SqlJoinFactory joinFactory, JdbcClient jdbcClient, SqlContext context, QueryType queryType, QueryData queryData) {
        super(logger, joinFactory, jdbcClient, context, queryType);
        this.logger = logger;
        this.fieldResolver = new SqlFieldResolver(this.getAliasManager(), queryData.getSelectSets());
    }

    @Override
    public void build(List<SqlHandler<?>> handlers) throws OseeCoreException {
        super.build(handlers);
        this.getContext().setObjectDescription(this.fieldResolver.getResult());
    }

    @Override
    protected void write(Iterable<SqlHandler<?>> handlers) throws OseeCoreException {
        List<SqlHandler<?>> xtraHandlers;
        this.withTxFilterClause = null;
        this.fieldResolver.reset();
        this.reset();
        this.computeTxFilterClause(handlers);
        this.computeTables(handlers);
        this.fieldResolver.resolve();
        this.computeWithClause(handlers);
        if (this.fieldResolver.hasUnresolvedFields()) {
            xtraHandlers = this.getFieldResolvers(this.fieldResolver.getUnresolved());
            this.computeTables(xtraHandlers);
            this.fieldResolver.resolve();
        } else {
            xtraHandlers = Collections.emptyList();
        }
        this.writeWithClause();
        this.writeSelect(handlers);
        this.write("\n FROM \n", new Object[0]);
        this.writeTables();
        this.write("\n WHERE \n", new Object[0]);
        this.writePredicates(Iterables.concat(handlers, xtraHandlers));
        if (this.toString().endsWith("\n WHERE \n")) {
            this.removeDanglingSeparator("\n WHERE \n");
        }
        this.writeGroupAndOrder();
    }

    @Override
    public void writeSelect(Iterable<SqlHandler<?>> handlers) throws OseeCoreException {
        if (this.isCountQueryType()) {
            throw new UnsupportedOperationException("Count dynamic query not supported");
        }
        this.write("SELECT%s ", this.getSqlHint());
        this.writeSelects(this.fieldResolver.getResult());
    }

    private void writeSelects(ResultObjectDescription result) {
        MutableBoolean isFirst = new MutableBoolean(true);
        for (DynamicData data : result.getDynamicData()) {
            this.writeSelects(data, isFirst);
        }
    }

    private void writeSelects(DynamicData data, MutableBoolean isFirst) {
        if (data instanceof DynamicObject) {
            DynamicObject object = (DynamicObject)data;
            for (DynamicData child : object.getChildren()) {
                this.writeSelects(child, isFirst);
            }
        } else {
            Map<String, String> columnInfo = SqlFieldResolver.getColumnInfo(data);
            for (Map.Entry<String, String> entry : columnInfo.entrySet()) {
                if (!isFirst.getValue()) {
                    this.write(", ", new Object[0]);
                } else {
                    isFirst.setValue(false);
                }
                String columnUuid = entry.getKey();
                String qualifiedColumn = entry.getValue();
                this.write(qualifiedColumn, new Object[0]);
                this.write(" as ", new Object[0]);
                this.write(columnUuid, new Object[0]);
            }
        }
    }

    @Override
    public void writeGroupAndOrder() throws OseeCoreException {
        if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            throw new UnsupportedOperationException("Historical dynamic query not supported");
        }
        if (!this.isCountQueryType()) {
            boolean isFirst = true;
            for (String value : this.fieldResolver.getSortFields()) {
                if (isFirst) {
                    isFirst = false;
                    this.write("\n ORDER BY ", new Object[0]);
                } else {
                    this.write(", ", new Object[0]);
                }
                this.write(value, new Object[0]);
            }
        } else if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            throw new UnsupportedOperationException("Historical Count dynamic query not supported");
        }
    }

    @Override
    public String getWithClauseTxBranchFilter(String txsAlias, boolean deletedPredicate) throws OseeCoreException {
        StringBuilder sb = new StringBuilder();
        if (deletedPredicate) {
            boolean allowDeleted = OptionsUtil.areDeletedArtifactsIncluded((Options)this.getOptions()) || OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions()) || OptionsUtil.areDeletedRelationsIncluded((Options)this.getOptions());
            this.writeTxFilter(txsAlias, sb, allowDeleted);
        } else if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            sb.append(txsAlias);
            sb.append(".transaction_id <= ?");
            this.addParameter(OptionsUtil.getFromTransaction((Options)this.getOptions()));
        }
        if (this.withTxFilterClause != null) {
            sb.append("\n AND \n   ");
            sb.append(txsAlias);
            sb.append(".branch_id = ");
            sb.append("(");
            sb.append(this.withTxFilterClause.getSql());
            sb.append(")");
            if (this.withTxFilterClause.hasParameters()) {
                for (Object param : this.withTxFilterClause.getParameters()) {
                    this.addParameter(param);
                }
            }
            if (this.withTxFilterClause.hasJoins()) {
                for (AbstractJoinQuery join : this.withTxFilterClause.getJoins()) {
                    this.getContext().getJoins().add(join);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String getTxBranchFilter(String txsAlias) {
        boolean allowDeleted = OptionsUtil.areDeletedArtifactsIncluded((Options)this.getOptions()) || OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions()) || OptionsUtil.areDeletedRelationsIncluded((Options)this.getOptions());
        return this.getTxBranchFilter(txsAlias, allowDeleted);
    }

    @Override
    public String getTxBranchFilter(String txsAlias, boolean allowDeleted) {
        StringBuilder sb = new StringBuilder();
        this.writeTxFilter(txsAlias, sb, allowDeleted);
        if (this.hasAlias(TableEnum.BRANCH_TABLE)) {
            String alias = this.getFirstAlias(TableEnum.BRANCH_TABLE);
            sb.append(" AND ");
            sb.append(txsAlias);
            sb.append(".branch_id = ");
            sb.append(alias);
            sb.append(".branch_id");
        } else if (this.hasAlias(TableEnum.TX_DETAILS_TABLE)) {
            String alias = this.getFirstAlias(TableEnum.TX_DETAILS_TABLE);
            sb.append(" AND ");
            sb.append(txsAlias);
            sb.append(".transaction_id = ");
            sb.append(alias);
            sb.append(".transaction_id");
            sb.append(" AND ");
            sb.append(txsAlias);
            sb.append(".branch_id = ");
            sb.append(alias);
            sb.append(".branch_id");
        }
        return sb.toString();
    }

    private void writeTxFilter(String txsAlias, StringBuilder sb, boolean allowDeleted) {
        if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            sb.append(txsAlias);
            sb.append(".transaction_id <= ?");
            this.addParameter(OptionsUtil.getFromTransaction((Options)this.getOptions()));
            if (!allowDeleted) {
                this.writeAndLn();
                sb.append(txsAlias);
                sb.append(".mod_type <> ");
                sb.append(String.valueOf(ModificationType.DELETED.getValue()));
            }
        } else {
            sb.append(txsAlias);
            sb.append(".tx_current");
            if (allowDeleted) {
                sb.append(" IN (");
                sb.append(String.valueOf(TxChange.CURRENT.getValue()));
                sb.append(", ");
                sb.append(String.valueOf(TxChange.DELETED.getValue()));
                sb.append(", ");
                sb.append(String.valueOf(TxChange.ARTIFACT_DELETED.getValue()));
                sb.append(")");
            } else {
                sb.append(" = ");
                sb.append(String.valueOf(TxChange.CURRENT.getValue()));
            }
        }
    }

    private void computeTxFilterClause(Iterable<SqlHandler<?>> handlers) {
        ArrayList branchHandlers = new ArrayList();
        ArrayList txHandlers = new ArrayList();
        ArrayList artHandlers = new ArrayList();
        for (SqlHandler<?> handler : handlers) {
            if (handler.getPriority() <= SqlHandlerPriority.ALL_BRANCHES.ordinal()) {
                branchHandlers.add(handler);
                continue;
            }
            if (handler.getPriority() <= SqlHandlerPriority.ALL_TXS.ordinal()) {
                txHandlers.add(handler);
                continue;
            }
            artHandlers.add(handler);
        }
        if (!artHandlers.isEmpty()) {
            TableEnum table = null;
            ArrayList withQueryHandlers = null;
            if (!branchHandlers.isEmpty()) {
                withQueryHandlers = branchHandlers;
                table = TableEnum.BRANCH_TABLE;
            } else if (!txHandlers.isEmpty()) {
                withQueryHandlers = txHandlers;
                table = TableEnum.TX_DETAILS_TABLE;
            }
            if (withQueryHandlers != null && table != null) {
                this.computeTables(withQueryHandlers);
                this.computeWithClause(withQueryHandlers);
                this.write("\n FROM \n", new Object[0]);
                this.writeTables();
                this.write("\n WHERE \n", new Object[0]);
                this.writePredicates(withQueryHandlers);
                String tbAlias = this.getFirstAlias(table);
                StringBuilder withBuilder = new StringBuilder();
                withBuilder.append("SELECT DISTINCT ");
                withBuilder.append(tbAlias);
                withBuilder.append(".branch_id ");
                withBuilder.append(this.toString());
                SqlContext context = this.getContext();
                String sql = withBuilder.toString().replaceAll("\\s+", " ");
                ArrayList joins = Lists.newArrayList(context.getJoins());
                ArrayList parameters = Lists.newArrayList(context.getParameters());
                this.withTxFilterClause = new WithClauseTxFilterData(sql, joins, parameters);
                this.reset();
            }
        }
    }

    private List<SqlHandler<?>> getFieldResolvers(Iterable<DynamicData> datas) {
        ArrayList toReturn = new ArrayList();
        HashSet<String> created = new HashSet<String>();
        for (DynamicData data : datas) {
            SqlHandler<?> handler;
            ObjectType type;
            ObjectField objectField;
            TableEnum table;
            int level = data.getLevel();
            String key = this.asKey(level, table = (objectField = SqlFieldResolver.getObjectField(data)).getTable(), type = objectField.getType());
            if (created.contains(key) || (handler = this.newSqlHandler(level, table, type)) == null) continue;
            created.add(key);
            toReturn.add(handler);
        }
        Collections.sort(toReturn, HANDLER_COMPARATOR);
        return toReturn;
    }

    private String asKey(int level, TableEnum table, ObjectType type) {
        return String.format("%s.%s.%s", new Object[]{level, table, type});
    }

    private SqlHandler<?> newSqlHandler(int level, TableEnum table, ObjectType type) {
        AbstractXtraTableSqlHandler handler = null;
        SqlHandlerPriority priority = this.getXtraSqlHandlerPriority(table, type);
        switch (table) {
            case TX_DETAILS_TABLE: {
                handler = new XtraTxDataSqlHandler(priority, type);
                break;
            }
            case BRANCH_TABLE: {
                handler = new XtraBranchDataSqlHandler(priority, type);
                break;
            }
            case ATTRIBUTE_TABLE: {
                handler = new XtraAttributeDataSqlHandler();
                break;
            }
            case RELATION_TABLE: {
                handler = new XtraRelationDataSqlHandler();
                break;
            }
        }
        if (handler != null) {
            handler.setLevel(level);
            handler.setLogger(this.logger);
        }
        return handler;
    }

    private SqlHandlerPriority getXtraSqlHandlerPriority(TableEnum table, ObjectType type) {
        SqlHandlerPriority priority = SqlHandlerPriority.LAST;
        if (type != null) {
            switch (type) {
                case ARTIFACT: {
                    priority = SqlHandlerPriority.ARTIFACT_TX_DATA_XTRA;
                    break;
                }
                case ATTRIBUTE: {
                    priority = SqlHandlerPriority.ATTRIBUTE_TX_DATA_XTRA;
                    break;
                }
                case RELATION: {
                    priority = SqlHandlerPriority.RELATION_TX_DATA_XTRA;
                    break;
                }
                case BRANCH: {
                    priority = SqlHandlerPriority.BRANCH_TX_DATA_XTRA;
                    break;
                }
            }
        }
        return priority;
    }

    private static final class WithClauseTxFilterData {
        private final String sql;
        private final List<AbstractJoinQuery> withJoins;
        private final List<Object> withParameters;

        public WithClauseTxFilterData(String sql, List<AbstractJoinQuery> withJoins, List<Object> withParameters) {
            this.sql = sql;
            this.withJoins = withJoins;
            this.withParameters = withParameters;
        }

        public boolean hasJoins() {
            return this.withJoins != null && !this.withJoins.isEmpty();
        }

        public boolean hasParameters() {
            return this.withParameters != null && !this.withParameters.isEmpty();
        }

        public String getSql() {
            return this.sql;
        }

        public List<AbstractJoinQuery> getJoins() {
            return this.withJoins;
        }

        public List<Object> getParameters() {
            return this.withParameters;
        }
    }
}

