/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import java.util.List;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContextFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.ObjectQuerySqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.QueryType;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class ObjectQuerySqlContextFactoryImpl
implements QuerySqlContextFactory {
    private final Log logger;
    private final SqlHandlerFactory handlerFactory;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;

    public ObjectQuerySqlContextFactoryImpl(Log logger, SqlJoinFactory joinFactory, JdbcClient jdbcClient, SqlHandlerFactory handlerFactory) {
        this.logger = logger;
        this.joinFactory = joinFactory;
        this.jdbcClient = jdbcClient;
        this.handlerFactory = handlerFactory;
    }

    @Override
    public QuerySqlContext createQueryContext(OrcsSession session, QueryData queryData, QueryType queryType) {
        QuerySqlContext context = new QuerySqlContext(session, queryData.getOptions(), QuerySqlContext.ObjectQueryType.DYNAMIC_OBJECT);
        ObjectQuerySqlWriter writer = new ObjectQuerySqlWriter(this.logger, this.joinFactory, this.jdbcClient, context, queryType, queryData);
        List<SqlHandler<?>> handlers = this.handlerFactory.createHandlers(queryData.getCriteriaSets());
        ((AbstractSqlWriter)writer).build(handlers);
        return context;
    }
}

