/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.executor.admin.HasCancellation;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.CountingLoadDataHandler;
import org.eclipse.osee.orcs.core.ds.DataLoader;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.QueryContext;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.db.internal.search.QueryCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.QueryFilterFactory;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContextFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.AbstractSearchCallable;
import org.eclipse.osee.orcs.db.internal.search.engines.QueryFilterFactoryImpl;
import org.eclipse.osee.orcs.db.internal.sql.QueryType;

public class ObjectQueryCallableFactory
implements QueryCallableFactory {
    private final Log logger;
    private final DataLoaderFactory objectLoader;
    private final QuerySqlContextFactory queryContextFactory;
    private final QueryFilterFactory factory;

    public ObjectQueryCallableFactory(Log logger, DataLoaderFactory objectLoader, QuerySqlContextFactory queryEngine, QueryFilterFactoryImpl factory) {
        this.logger = logger;
        this.objectLoader = objectLoader;
        this.queryContextFactory = queryEngine;
        this.factory = factory;
    }

    @Override
    public CancellableCallable<Integer> createCount(OrcsSession session, QueryData queryData) {
        return new AbstractObjectSearchCallable(this, this.logger, session, queryData){

            @Override
            protected Integer innerCall() throws Exception {
                int count = -1;
                count = this.isPostProcessRequired() ? this.loadAndGetCount(null, true) : this.getCount();
                this.checkForCancelled();
                return count;
            }

            protected int getCount() throws OseeCoreException {
                QuerySqlContext queryContext = queryContextFactory.createQueryContext(this.getSession(), this.getQueryData(), QueryType.COUNT);
                this.checkForCancelled();
                return objectLoader.getCount((HasCancellation)this, (QueryContext)queryContext);
            }
        };
    }

    @Override
    public CancellableCallable<Integer> createQuery(OrcsSession session, QueryData queryData, final LoadDataHandler handler) {
        return new AbstractObjectSearchCallable(this, this.logger, session, queryData){

            @Override
            protected Integer innerCall() throws Exception {
                boolean enableFilter = this.isPostProcessRequired();
                return this.loadAndGetCount(handler, enableFilter);
            }
        };
    }

    private abstract class AbstractObjectSearchCallable
    extends AbstractSearchCallable {
        public AbstractObjectSearchCallable(Log logger, OrcsSession session, QueryData queryData) {
            super(logger, session, queryData);
        }

        private boolean isLoadLevelTooLow(LoadLevel level) {
            return LoadLevel.ARTIFACT_DATA == level;
        }

        protected boolean isPostProcessRequired() {
            return ObjectQueryCallableFactory.this.factory.isFilterRequired(this.getQueryData());
        }

        protected int loadAndGetCount(LoadDataHandler handler, boolean enableFilter) throws Exception {
            LoadLevel level;
            QuerySqlContext queryContext = ObjectQueryCallableFactory.this.queryContextFactory.createQueryContext(this.getSession(), this.getQueryData(), QueryType.SELECT);
            this.checkForCancelled();
            DataLoader loader = ObjectQueryCallableFactory.this.objectLoader.newDataLoader((QueryContext)queryContext);
            loader.setOptions(this.getQueryData().getOptions());
            if (enableFilter && this.isLoadLevelTooLow(level = loader.getLoadLevel())) {
                loader.withLoadLevel(LoadLevel.ARTIFACT_AND_ATTRIBUTE_DATA);
            }
            CountingLoadDataHandler countingHandler = ObjectQueryCallableFactory.this.factory.createHandler((HasCancellation)this, this.getQueryData(), queryContext, handler);
            loader.load((HasCancellation)this, (LoadDataHandler)countingHandler);
            return countingHandler.getCount();
        }
    }
}

