/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.ObjectType;
import org.eclipse.osee.orcs.db.internal.sql.QueryType;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class ArtifactQuerySqlWriter
extends AbstractSqlWriter {
    private final BranchId branch;

    public ArtifactQuerySqlWriter(Log logger, SqlJoinFactory joinFactory, JdbcClient jdbcClient, SqlContext context, QueryType queryType, BranchId branch) {
        super(logger, joinFactory, jdbcClient, context, queryType);
        this.branch = branch;
    }

    private void writeSelectHelper() throws OseeCoreException {
        String txAlias = this.getLastAlias(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
        String artAlias = this.getLastAlias(TableEnum.ARTIFACT_TABLE);
        this.write("SELECT%s ", this.getSqlHint());
        if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            this.write("%s.transaction_id, %s.art_id, %s.branch_id", txAlias, artAlias, txAlias);
        } else {
            this.write("%s.art_id, %s.branch_id", artAlias, txAlias);
        }
    }

    @Override
    public void writeSelect(Iterable<SqlHandler<?>> handlers) throws OseeCoreException {
        if (this.isCountQueryType()) {
            if (OptionsUtil.isHistorical((Options)this.getOptions())) {
                this.write("SELECT count(xTable.art_id) FROM (\n ", new Object[0]);
                this.writeSelectHelper();
            } else {
                String artAlias = this.getLastAlias(TableEnum.ARTIFACT_TABLE);
                this.write("SELECT%s count(%s.art_id)", this.getSqlHint(), artAlias);
            }
        } else {
            this.writeSelectHelper();
        }
    }

    @Override
    public void writeGroupAndOrder() throws OseeCoreException {
        if (!this.isCountQueryType()) {
            String txAlias = this.getLastAlias(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
            String artAlias = this.getLastAlias(TableEnum.ARTIFACT_TABLE);
            this.write("\n ORDER BY %s.art_id, %s.branch_id", artAlias, txAlias);
        } else if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            this.write("\n) xTable", new Object[0]);
        }
    }

    @Override
    public String getTxBranchFilter(String txsAlias) {
        boolean allowDeleted = OptionsUtil.areDeletedArtifactsIncluded((Options)this.getOptions()) || OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions()) || OptionsUtil.areDeletedRelationsIncluded((Options)this.getOptions());
        StringBuilder sb = new StringBuilder();
        this.writeTxFilter(txsAlias, sb, allowDeleted);
        if (!this.branch.isValid()) {
            throw new OseeArgumentException("getTxBranchFilter: branch uuid must be > 0", new Object[0]);
        }
        sb.append(" AND ");
        sb.append(txsAlias);
        sb.append(".branch_id = ?");
        this.addParameter(this.branch);
        return sb.toString();
    }

    @Override
    public String getTxBranchFilter(String txsAlias, boolean allowDeleted) {
        StringBuilder sb = new StringBuilder();
        this.writeTxFilter(txsAlias, sb, allowDeleted);
        if (this.branch.isValid()) {
            sb.append(" AND ");
            sb.append(txsAlias);
            sb.append(".branch_id = ?");
            this.addParameter(this.branch);
        }
        return sb.toString();
    }

    private void writeTxFilter(String txsAlias, StringBuilder sb, boolean allowDeleted) {
        if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            if (allowDeleted) {
                this.removeDanglingSeparator("\n AND \n");
                this.removeDanglingSeparator(" AND ");
            } else {
                sb.append(txsAlias);
                sb.append(".mod_type <> ");
                sb.append(String.valueOf(ModificationType.DELETED.getValue()));
            }
        } else {
            sb.append(txsAlias);
            sb.append(".tx_current");
            if (allowDeleted) {
                sb.append(" <> ");
                sb.append(String.valueOf(TxChange.NOT_CURRENT.getValue()));
            } else {
                sb.append(" = ");
                sb.append(String.valueOf(TxChange.CURRENT.getValue()));
            }
        }
    }

    @Override
    public String getWithClauseTxBranchFilter(String txsAlias, boolean deletedPredicate) throws OseeCoreException {
        StringBuilder sb = new StringBuilder();
        if (deletedPredicate) {
            boolean allowDeleted = OptionsUtil.areDeletedArtifactsIncluded((Options)this.getOptions()) || OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions()) || OptionsUtil.areDeletedRelationsIncluded((Options)this.getOptions());
            this.writeTxFilter(txsAlias, sb, allowDeleted);
        } else if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            sb.append(txsAlias);
            sb.append(".transaction_id <= ?");
            this.addParameter(OptionsUtil.getFromTransaction((Options)this.getOptions()));
        }
        if (this.branch.isValid()) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(txsAlias);
            sb.append(".branch_id = ?");
            this.addParameter(this.branch);
        }
        return sb.toString();
    }
}

