/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.HasBranch;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContextFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.ArtifactQuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.engines.ArtifactQuerySqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.QueryType;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class ArtifactQuerySqlContextFactoryImpl
implements QuerySqlContextFactory {
    private final Log logger;
    private final SqlHandlerFactory handlerFactory;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;

    public ArtifactQuerySqlContextFactoryImpl(Log logger, SqlJoinFactory joinFactory, JdbcClient jdbcClient, SqlHandlerFactory handlerFactory) {
        this.logger = logger;
        this.joinFactory = joinFactory;
        this.jdbcClient = jdbcClient;
        this.handlerFactory = handlerFactory;
    }

    @Override
    public QuerySqlContext createQueryContext(OrcsSession session, QueryData queryData, QueryType queryType) {
        QuerySqlContext context = this.createContext(session, queryData);
        AbstractSqlWriter writer = this.createQueryWriter(context, queryData, queryType);
        List<SqlHandler<?>> handlers = this.handlerFactory.createHandlers(queryData.getCriteriaSets());
        writer.build(handlers);
        return context;
    }

    private QuerySqlContext createContext(OrcsSession session, QueryData queryData) throws OseeCoreException {
        BranchId branch = this.getBranchToSearch(queryData);
        Conditions.checkNotNull((Object)branch, (String)"branch");
        return new ArtifactQuerySqlContext(session, branch, queryData.getOptions());
    }

    private AbstractSqlWriter createQueryWriter(SqlContext context, QueryData queryData, QueryType queryType) throws OseeCoreException {
        BranchId branch = this.getBranchToSearch(queryData);
        Conditions.checkNotNull((Object)branch, (String)"branch");
        return new ArtifactQuerySqlWriter(this.logger, this.joinFactory, this.jdbcClient, context, queryType, branch);
    }

    private BranchId getBranchToSearch(QueryData queryData) throws OseeCoreException {
        BranchId branch = BranchId.SENTINEL;
        List criterias = queryData.getAllCriteria();
        Optional item = Iterables.tryFind((Iterable)criterias, (Predicate)new Predicate<Criteria>(){

            public boolean apply(Criteria criteria) {
                return HasBranch.class.isAssignableFrom(criteria.getClass());
            }
        });
        if (item.isPresent()) {
            HasBranch criteria = (HasBranch)item.get();
            branch = criteria.getBranch();
        }
        return branch;
    }
}

