/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.executor.admin.HasCancellation;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.DataLoader;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.QueryContext;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.db.internal.search.QueryCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContextFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.AbstractSearchCallable;
import org.eclipse.osee.orcs.db.internal.sql.QueryType;

public abstract class AbstractSimpleQueryCallableFactory
implements QueryCallableFactory {
    private final Log logger;
    private final DataLoaderFactory objectLoader;
    private final QuerySqlContextFactory queryContextFactory;

    public AbstractSimpleQueryCallableFactory(Log logger, DataLoaderFactory objectLoader, QuerySqlContextFactory queryEngine) {
        this.logger = logger;
        this.objectLoader = objectLoader;
        this.queryContextFactory = queryEngine;
    }

    @Override
    public CancellableCallable<Integer> createCount(OrcsSession session, QueryData queryData) {
        return new AbstractSearchCallable(this.logger, session, queryData){

            @Override
            protected Integer innerCall() throws Exception {
                QuerySqlContext queryContext = AbstractSimpleQueryCallableFactory.this.queryContextFactory.createQueryContext(this.getSession(), this.getQueryData(), QueryType.COUNT);
                this.checkForCancelled();
                return AbstractSimpleQueryCallableFactory.this.objectLoader.getCount((HasCancellation)this, (QueryContext)queryContext);
            }
        };
    }

    @Override
    public CancellableCallable<Integer> createQuery(OrcsSession session, QueryData queryData, final LoadDataHandler handler) {
        return new AbstractSearchCallable(this.logger, session, queryData){

            @Override
            protected Integer innerCall() throws Exception {
                QuerySqlContext queryContext = AbstractSimpleQueryCallableFactory.this.queryContextFactory.createQueryContext(this.getSession(), this.getQueryData(), QueryType.SELECT);
                this.checkForCancelled();
                DataLoader loader = AbstractSimpleQueryCallableFactory.this.objectLoader.newDataLoader((QueryContext)queryContext);
                loader.setOptions(this.getQueryData().getOptions());
                AtomicInteger counter = new AtomicInteger();
                LoadDataHandler countingHandler = AbstractSimpleQueryCallableFactory.this.createCountingHandler(counter, handler);
                loader.load((HasCancellation)this, countingHandler);
                return counter.get();
            }
        };
    }

    protected abstract LoadDataHandler createCountingHandler(AtomicInteger var1, LoadDataHandler var2);
}

