/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search;

import org.eclipse.osee.executor.admin.ExecutorAdmin;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.ds.QueryEngineIndexer;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.IdentityLocator;
import org.eclipse.osee.orcs.db.internal.search.Engines;
import org.eclipse.osee.orcs.db.internal.search.QueryCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.ObjectQueryCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.QueryEngineImpl;
import org.eclipse.osee.orcs.db.internal.search.tagger.TaggingEngine;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class QueryModule {
    private final Log logger;
    private final ExecutorAdmin executorAdmin;
    private final JdbcClient jdbcClient;
    private final IdentityLocator idService;
    private final SqlJoinFactory sqlJoinFactory;
    private TaggingEngine taggingEngine;
    private QueryEngineIndexer queryIndexer;

    public QueryModule(Log logger, ExecutorAdmin executorAdmin, JdbcClient jdbcClient, SqlJoinFactory sqlJoinFactory, IdentityLocator idService) {
        this.logger = logger;
        this.executorAdmin = executorAdmin;
        this.jdbcClient = jdbcClient;
        this.sqlJoinFactory = sqlJoinFactory;
        this.idService = idService;
    }

    public void startIndexer(IResourceManager resourceManager) throws Exception {
        this.taggingEngine = Engines.newTaggingEngine(this.logger);
        this.queryIndexer = Engines.newIndexingEngine(this.logger, this.jdbcClient, this.sqlJoinFactory, this.taggingEngine, this.executorAdmin, resourceManager);
        this.executorAdmin.createFixedPoolExecutor("indexing.consumer.executor.id", 4);
    }

    public void stopIndexer() throws Exception {
        this.queryIndexer = null;
        this.taggingEngine = null;
        this.executorAdmin.shutdown("indexing.consumer.executor.id");
    }

    public QueryEngineIndexer getQueryIndexer() {
        return this.queryIndexer;
    }

    public QueryEngine createQueryEngine(DataLoaderFactory objectLoader, AttributeTypes attrTypes) {
        ObjectQueryCallableFactory factory1 = Engines.newArtifactQueryEngine(this.logger, this.sqlJoinFactory, this.idService, this.jdbcClient, this.taggingEngine, this.executorAdmin, objectLoader, attrTypes);
        QueryCallableFactory factory2 = Engines.newBranchQueryEngine(this.logger, this.sqlJoinFactory, this.idService, this.jdbcClient, objectLoader);
        QueryCallableFactory factory3 = Engines.newTxQueryEngine(this.logger, this.sqlJoinFactory, this.idService, this.jdbcClient, objectLoader);
        QueryCallableFactory factory4 = Engines.newQueryEngine(this.logger, this.sqlJoinFactory, this.idService, this.jdbcClient, this.taggingEngine, this.executorAdmin, objectLoader, attrTypes);
        return new QueryEngineImpl(factory1, factory2, factory3, factory4, this.jdbcClient, this.sqlJoinFactory);
    }
}

