/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.osee.executor.admin.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.BranchData;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.LoadDataHandlerDecorator;
import org.eclipse.osee.orcs.core.ds.QueryEngineIndexer;
import org.eclipse.osee.orcs.core.ds.TxOrcsData;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.IdentityLocator;
import org.eclipse.osee.orcs.db.internal.search.QueryCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContextFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.AbstractSimpleQueryCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.ArtifactQuerySqlContextFactoryImpl;
import org.eclipse.osee.orcs.db.internal.search.engines.ObjectQueryCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.ObjectQuerySqlContextFactoryImpl;
import org.eclipse.osee.orcs.db.internal.search.engines.QueryFilterFactoryImpl;
import org.eclipse.osee.orcs.db.internal.search.engines.QuerySqlContextFactoryImpl;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerFactoryUtil;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexerCallableFactoryImpl;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexingTaskConsumerImpl;
import org.eclipse.osee.orcs.db.internal.search.indexer.QueryEngineIndexerImpl;
import org.eclipse.osee.orcs.db.internal.search.indexer.data.GammaQueueIndexerDataSourceLoader;
import org.eclipse.osee.orcs.db.internal.search.language.EnglishLanguage;
import org.eclipse.osee.orcs.db.internal.search.tagger.StreamMatcher;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagEncoder;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagProcessor;
import org.eclipse.osee.orcs.db.internal.search.tagger.Tagger;
import org.eclipse.osee.orcs.db.internal.search.tagger.TaggingEngine;
import org.eclipse.osee.orcs.db.internal.search.tagger.TextStreamTagger;
import org.eclipse.osee.orcs.db.internal.search.tagger.XmlTagger;
import org.eclipse.osee.orcs.db.internal.search.util.AttributeDataMatcher;
import org.eclipse.osee.orcs.db.internal.search.util.MatcherFactory;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.TableEnum;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public final class Engines {
    private Engines() {
    }

    public static ObjectQueryCallableFactory newArtifactQueryEngine(Log logger, SqlJoinFactory joinFactory, IdentityLocator idService, JdbcClient jdbcClient, TaggingEngine taggingEngine, ExecutorAdmin executorAdmin, DataLoaderFactory objectLoader, AttributeTypes attrTypes) {
        SqlHandlerFactory handlerFactory = SqlHandlerFactoryUtil.createArtifactSqlHandlerFactory(logger, idService, taggingEngine.getTagProcessor());
        ArtifactQuerySqlContextFactoryImpl sqlContextFactory = new ArtifactQuerySqlContextFactoryImpl(logger, joinFactory, jdbcClient, handlerFactory);
        AttributeDataMatcher matcher = new AttributeDataMatcher(logger, taggingEngine, attrTypes);
        QueryFilterFactoryImpl filterFactory = new QueryFilterFactoryImpl(logger, executorAdmin, matcher);
        return new ObjectQueryCallableFactory(logger, objectLoader, sqlContextFactory, filterFactory);
    }

    public static QueryCallableFactory newBranchQueryEngine(Log logger, SqlJoinFactory joinFactory, IdentityLocator idService, JdbcClient jdbcClient, DataLoaderFactory objectLoader) {
        QuerySqlContextFactory sqlContextFactory = Engines.newBranchSqlContextFactory(logger, joinFactory, idService, jdbcClient);
        return new AbstractSimpleQueryCallableFactory(logger, objectLoader, sqlContextFactory){

            @Override
            protected LoadDataHandler createCountingHandler(final AtomicInteger counter, LoadDataHandler handler) {
                return new LoadDataHandlerDecorator(handler){

                    public void onData(BranchData data) throws OseeCoreException {
                        counter.getAndIncrement();
                        super.onData(data);
                    }
                };
            }
        };
    }

    public static QueryCallableFactory newTxQueryEngine(Log logger, SqlJoinFactory joinFactory, IdentityLocator idService, JdbcClient jdbcClient, DataLoaderFactory objectLoader) {
        QuerySqlContextFactory sqlContextFactory = Engines.newTxSqlContextFactory(logger, joinFactory, idService, jdbcClient);
        return new AbstractSimpleQueryCallableFactory(logger, objectLoader, sqlContextFactory){

            @Override
            protected LoadDataHandler createCountingHandler(final AtomicInteger counter, LoadDataHandler handler) {
                return new LoadDataHandlerDecorator(handler){

                    public void onData(TxOrcsData data) throws OseeCoreException {
                        counter.getAndIncrement();
                        super.onData(data);
                    }
                };
            }
        };
    }

    public static QueryCallableFactory newQueryEngine(Log logger, SqlJoinFactory joinFactory, IdentityLocator idService, JdbcClient jdbcClient, TaggingEngine taggingEngine, ExecutorAdmin executorAdmin, DataLoaderFactory objectLoader, AttributeTypes attrTypes) {
        SqlHandlerFactory handlerFactory = SqlHandlerFactoryUtil.createObjectSqlHandlerFactory(logger, idService, taggingEngine.getTagProcessor());
        ObjectQuerySqlContextFactoryImpl sqlContextFactory = new ObjectQuerySqlContextFactoryImpl(logger, joinFactory, jdbcClient, handlerFactory);
        AttributeDataMatcher matcher = new AttributeDataMatcher(logger, taggingEngine, attrTypes);
        QueryFilterFactoryImpl filterFactory = new QueryFilterFactoryImpl(logger, executorAdmin, matcher);
        return new ObjectQueryCallableFactory(logger, objectLoader, sqlContextFactory, filterFactory);
    }

    public static TaggingEngine newTaggingEngine(Log logger) {
        TagProcessor tagProcessor = new TagProcessor(new EnglishLanguage(logger), new TagEncoder());
        HashMap<String, Tagger> taggers = new HashMap<String, Tagger>();
        StreamMatcher matcher = MatcherFactory.createMatcher();
        taggers.put("DefaultAttributeTaggerProvider", new TextStreamTagger(tagProcessor, matcher));
        taggers.put("XmlAttributeTaggerProvider", new XmlTagger(tagProcessor, matcher));
        return new TaggingEngine(taggers, tagProcessor);
    }

    public static QuerySqlContextFactory newSqlContextFactory(Log logger, SqlJoinFactory joinFactory, JdbcClient jdbcClient, TableEnum table, String idColumn, SqlHandlerFactory handlerFactory, QuerySqlContext.ObjectQueryType type) {
        return new QuerySqlContextFactoryImpl(logger, joinFactory, jdbcClient, handlerFactory, table, idColumn, type);
    }

    public static QuerySqlContextFactory newBranchSqlContextFactory(Log logger, SqlJoinFactory joinFactory, IdentityLocator idService, JdbcClient jdbcClient) {
        SqlHandlerFactory handlerFactory = SqlHandlerFactoryUtil.createBranchSqlHandlerFactory(logger, idService);
        return Engines.newSqlContextFactory(logger, joinFactory, jdbcClient, TableEnum.BRANCH_TABLE, "branch_id", handlerFactory, QuerySqlContext.ObjectQueryType.BRANCH);
    }

    public static QuerySqlContextFactory newTxSqlContextFactory(Log logger, SqlJoinFactory joinFactory, IdentityLocator idService, JdbcClient jdbcClient) {
        SqlHandlerFactory handlerFactory = SqlHandlerFactoryUtil.createTxSqlHandlerFactory(logger, idService);
        return Engines.newSqlContextFactory(logger, joinFactory, jdbcClient, TableEnum.TX_DETAILS_TABLE, "transaction_id", handlerFactory, QuerySqlContext.ObjectQueryType.TX);
    }

    public static QueryEngineIndexer newIndexingEngine(Log logger, JdbcClient jdbcClient, SqlJoinFactory sqlJoinFactory, TaggingEngine taggingEngine, ExecutorAdmin executorAdmin, IResourceManager resourceManager) {
        GammaQueueIndexerDataSourceLoader resourceLoader = new GammaQueueIndexerDataSourceLoader(logger, jdbcClient, resourceManager);
        IndexerCallableFactoryImpl callableFactory = new IndexerCallableFactoryImpl(logger, jdbcClient, taggingEngine, resourceLoader);
        IndexingTaskConsumerImpl indexConsumer = new IndexingTaskConsumerImpl(executorAdmin, callableFactory);
        return new QueryEngineIndexerImpl(logger, jdbcClient, sqlJoinFactory, indexConsumer);
    }
}

