/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.resource;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceLocatorProvider;
import org.eclipse.osee.framework.resource.management.exception.MalformedLocatorException;
import org.eclipse.osee.framework.resource.management.util.ResourceLocator;

public class AttributeLocatorProvider
implements IResourceLocatorProvider {
    public IResourceLocator generateResourceLocator(String seed, String name) throws OseeCoreException {
        URI uri = null;
        try {
            uri = new URI(this.generatePath(seed, name));
        }
        catch (Exception ex) {
            throw new MalformedLocatorException((Throwable)ex);
        }
        return new ResourceLocator(uri);
    }

    public IResourceLocator getResourceLocator(String path) throws OseeCoreException {
        URI uri = null;
        if (this.isPathValid(path)) {
            try {
                uri = new URI(path);
            }
            catch (Exception ex) {
                throw new MalformedLocatorException((Throwable)ex);
            }
        } else {
            throw new MalformedLocatorException("Invalid path hint: [%s]", new Object[]{path});
        }
        return new ResourceLocator(uri);
    }

    public boolean isValid(String protocol) {
        return Strings.isValid((String)protocol) && protocol.startsWith(this.getSupportedProtocol());
    }

    private boolean isPathValid(String value) {
        return Strings.isValid((String)value) && value.startsWith(String.valueOf(this.getSupportedProtocol()) + "://");
    }

    private String generatePath(String seed, String name) throws OseeCoreException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getSupportedProtocol());
        builder.append("://");
        if (Strings.isValid((String)seed) && Strings.isValid((String)name)) {
            try {
                char[] buffer = new char[3];
                int cnt = -1;
                StringReader in = new StringReader(seed);
                while ((cnt = in.read(buffer)) != -1) {
                    builder.append(buffer, 0, cnt);
                    builder.append("/");
                }
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        } else {
            throw new MalformedLocatorException("Invalid arguments during locator generation.", new Object[0]);
        }
        builder.append(name);
        return builder.toString();
    }

    public String getSupportedProtocol() {
        return "attr";
    }
}

