/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.core.ds.CharacterDataProxy;
import org.eclipse.osee.orcs.core.ds.ResourceNameResolver;
import org.eclipse.osee.orcs.db.internal.proxy.AbstractDataProxy;

public class VarCharDataProxy
extends AbstractDataProxy
implements CharacterDataProxy {
    private Object rawValue = "";

    public String getDisplayableString() throws OseeCoreException {
        return this.getValueAsString();
    }

    public void setDisplayableString(String toDisplay) {
        throw new UnsupportedOperationException();
    }

    public Object getValue() {
        Object fromStorage = this.getFromStorageAsObject();
        Object toReturn = null;
        if (fromStorage != null) {
            toReturn = fromStorage;
        } else if (this.rawValue != null) {
            toReturn = this.rawValue;
        }
        return toReturn != null ? toReturn : "";
    }

    public String getValueAsString() throws OseeCoreException {
        String fromStorage = this.getFromStorage();
        String toReturn = null;
        if (fromStorage != null) {
            toReturn = fromStorage;
        } else if (this.rawValue != null) {
            toReturn = this.rawValue.toString();
        }
        return toReturn != null ? toReturn : "";
    }

    public boolean setValue(Object value) throws OseeCoreException {
        boolean response = false;
        Object currentValue = value instanceof String ? this.getValueAsString() : this.getValue();
        if (currentValue == value || currentValue != null && currentValue.equals(value)) {
            response = false;
        } else {
            this.storeValue(value);
            response = true;
        }
        return response;
    }

    private Object getFromStorageAsObject() throws OseeCoreException {
        Object fromStorage = null;
        byte[] data = null;
        try {
            data = this.getStorage().getContent();
            if (data != null) {
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                ObjectInputStream is = new ObjectInputStream(in);
                try {
                    fromStorage = is.readObject();
                }
                catch (ClassNotFoundException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
            }
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return fromStorage;
    }

    private String getFromStorage() throws OseeCoreException {
        String fromStorage = null;
        byte[] data = null;
        try {
            data = this.getStorage().getContent();
            if (data != null) {
                data = Lib.decompressBytes((InputStream)new ByteArrayInputStream(data));
                fromStorage = new String(data, "UTF-8");
            }
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return fromStorage;
    }

    private void storeValue(Object value) throws OseeCoreException {
        if (value != null && value instanceof String && ((String)value).length() > 4000) {
            ResourceNameResolver resolver = this.getResolver();
            Conditions.checkNotNull((Object)resolver, (String)"ResourceNameResolver", (String)"Unable to determine internal file name", (Object[])new Object[0]);
            try {
                byte[] compressed = Lib.compressStream((InputStream)new ByteArrayInputStream(((String)value).getBytes("UTF-8")), (String)resolver.getInternalFileName());
                this.getStorage().setContent(compressed, "zip", "application/zip", "ISO-8859-1");
                this.rawValue = "";
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        } else {
            this.rawValue = value;
            this.getStorage().clear();
        }
    }

    public Object[] getData() {
        return new Object[]{this.rawValue, this.getStorage().getLocator()};
    }

    public void setData(Object ... objects) throws OseeCoreException {
        if (objects != null && objects.length > 1) {
            this.storeValue(objects[0]);
            this.getStorage().setLocator((String)objects[1]);
        }
    }

    public void persist(long storageId) throws OseeCoreException {
        this.getStorage().persist(storageId);
    }

    public void purge() throws OseeCoreException {
        this.getStorage().purge();
    }
}

