/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.db.internal.proxy.DataHandler;
import org.eclipse.osee.orcs.db.internal.proxy.DataResource;

public class Storage
extends DataResource {
    private final DataHandler handler;
    private byte[] rawContent;
    private volatile boolean initialized;

    public Storage(DataHandler handler) {
        this.handler = handler;
        this.clear();
        this.setInitialized(false);
    }

    @Override
    public void setLocator(String locator) {
        super.setLocator(locator);
        this.setInitialized(false);
    }

    public boolean isDataValid() {
        return this.rawContent != null && this.rawContent.length > 0;
    }

    public InputStream getInputStream() throws OseeCoreException {
        return new ByteArrayInputStream(this.getContent());
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isLoadingAllowed() {
        return !this.isInitialized() && this.isLocatorValid();
    }

    public byte[] getContent() throws OseeCoreException {
        if (this.isLoadingAllowed()) {
            this.rawContent = this.handler.acquire(this);
            this.setInitialized(true);
        }
        return this.rawContent;
    }

    public void persist(long storageId) throws OseeCoreException {
        if (this.isDataValid()) {
            this.handler.save(storageId, this, this.rawContent);
        }
    }

    public void purge() throws OseeCoreException {
        if (this.isLocatorValid()) {
            this.handler.delete(this);
        }
    }

    public void setContent(byte[] rawContent, String extension, String contentType, String encoding) {
        this.rawContent = rawContent;
        this.setContentType(contentType);
        this.setEncoding(encoding);
        this.setExtension(extension);
    }

    public void copyTo(Storage other) {
        other.rawContent = (byte[])(this.rawContent != null ? Arrays.copyOf(this.rawContent, this.rawContent.length) : null);
        other.setContentType(this.getContentType());
        other.setEncoding(this.getEncoding());
        other.setExtension(this.getExtension());
    }

    public void clear() {
        this.setContent(null, "txt", "txt/plain", "UTF-8");
        this.setLocator(null);
    }
}

