/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.osee.framework.core.exception.OseeDataStoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.orcs.core.ds.ResourceNameResolver;
import org.eclipse.osee.orcs.db.internal.proxy.DataHandler;
import org.eclipse.osee.orcs.db.internal.proxy.DataResource;
import org.eclipse.osee.orcs.db.internal.util.BinaryContentUtils;
import org.eclipse.osee.orcs.db.internal.util.ByteStreamResource;

public class ResourceHandler
implements DataHandler {
    private static final PropertyStore DEFAULT_OPTIONS = new PropertyStore();
    private final IResourceManager resourceManager;

    public ResourceHandler(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public byte[] acquire(DataResource dataResource) throws OseeCoreException {
        String path = dataResource.getLocator();
        Conditions.checkNotNull((Object)path, (String)"resource path");
        IResourceLocator locator = this.resourceManager.getResourceLocator(path);
        Conditions.checkNotNull((Object)locator, (String)"resource locator", (String)"Unable to locate resource: [%s]", (Object[])new Object[]{path});
        IResource resource = this.resourceManager.acquire(locator, DEFAULT_OPTIONS);
        String mimeType = BinaryContentUtils.getContentType(resource);
        byte[] data = null;
        InputStream inputStream = null;
        try {
            try {
                inputStream = resource.getContent();
                data = Lib.inputStreamToBytes((InputStream)inputStream);
            }
            catch (IOException ex) {
                throw new OseeCoreException((Throwable)ex, "Error acquiring resource - [%s]", new Object[]{dataResource});
            }
        }
        finally {
            Lib.close((Closeable)inputStream);
        }
        String extension = Lib.getExtension((String)resource.getName());
        if (Strings.isValid((String)extension)) {
            dataResource.setExtension(extension);
        }
        dataResource.setContentType(mimeType);
        dataResource.setEncoding("ISO-8859-1");
        return data;
    }

    @Override
    public void save(long storageId, DataResource dataResource, byte[] rawContent) throws OseeCoreException {
        StringBuilder storageName = new StringBuilder();
        ResourceNameResolver resolver = dataResource.getResolver();
        Conditions.checkNotNull((Object)resolver, (String)"resource name resolver");
        storageName.append(resolver.getStorageName());
        String extension = dataResource.getExtension();
        if (Strings.isValid((String)extension)) {
            storageName.append(".");
            storageName.append(extension);
        }
        String seed = String.valueOf(storageId);
        IResourceLocator locatorHint = this.resourceManager.generateResourceLocator("attr", seed, storageName.toString());
        String contentType = dataResource.getContentType();
        boolean isCompressed = Strings.isValid((String)contentType) && contentType.contains("zip");
        ByteStreamResource resource = new ByteStreamResource(locatorHint, rawContent, isCompressed);
        IResourceLocator locator = this.resourceManager.save(locatorHint, (IResource)resource, DEFAULT_OPTIONS);
        Conditions.checkNotNull((Object)locator, (String)"locator", (String)"Error saving resource [%s]", (Object[])new Object[]{locatorHint.getRawPath()});
        dataResource.setLocator(locator.getLocation().toASCIIString());
    }

    @Override
    public void delete(DataResource dataResource) throws OseeCoreException {
        String path = dataResource.getLocator();
        Conditions.checkNotNull((Object)path, (String)"resource path");
        IResourceLocator locator = this.resourceManager.getResourceLocator(path);
        Conditions.checkNotNull((Object)locator, (String)"resource locator", (String)"Unable to locate resource [%s]", (Object[])new Object[]{dataResource});
        int result = this.resourceManager.delete(locator);
        if (1 != result) {
            throw new OseeDataStoreException("Error deleting resource located at [%s]", new Object[]{dataResource.getLocator()});
        }
    }
}

