/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.DataProxyFactory;
import org.eclipse.osee.orcs.db.internal.proxy.AbstractDataProxy;
import org.eclipse.osee.orcs.db.internal.proxy.ResourceHandler;
import org.eclipse.osee.orcs.db.internal.proxy.Storage;
import org.eclipse.osee.orcs.db.internal.proxy.UriDataProxy;
import org.eclipse.osee.orcs.db.internal.proxy.VarCharDataProxy;

public class ResourceDataProxyFactory
implements DataProxyFactory {
    private final Map<String, Class<? extends AbstractDataProxy>> proxyClassMap = new HashMap<String, Class<? extends AbstractDataProxy>>();
    private Log logger;
    private IResourceManager resourceManager;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public Log getLogger() {
        return this.logger;
    }

    public IResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    private Class<? extends AbstractDataProxy> getProxyClazz(String id) {
        return this.proxyClassMap.get(id);
    }

    public void start(Map<String, Object> properties) throws Exception {
        Object object = properties.get("proxy.factory.alias");
        String[] factoryAliases = new String[]{};
        if (object instanceof String[]) {
            factoryAliases = (String[])object;
        }
        Conditions.checkNotNull((Object)factoryAliases, (String)"PROXY_FACTORY_ALIAS");
        this.proxyClassMap.put("DefaultAttributeDataProvider", VarCharDataProxy.class);
        this.proxyClassMap.put("ClobAttributeDataProvider", VarCharDataProxy.class);
        this.proxyClassMap.put("UriAttributeDataProvider", UriDataProxy.class);
        this.proxyClassMap.put("MappedAttributeDataProvider", UriDataProxy.class);
        List<String> aliases = Arrays.asList(factoryAliases);
        Set<String> keys = this.proxyClassMap.keySet();
        Conditions.checkExpressionFailOnTrue((!Collections.setComplement(aliases, keys).isEmpty() ? 1 : 0) != 0, (String)"Check osgi.ds declaration - property mismatch detected", (Object[])new Object[0]);
        Conditions.checkExpressionFailOnTrue((!Collections.setComplement(keys, aliases).isEmpty() ? 1 : 0) != 0, (String)"Check osgi.ds declaration - property mismatch detected", (Object[])new Object[0]);
    }

    public void stop() {
        this.proxyClassMap.clear();
    }

    public DataProxy createInstance(String factoryAlias) throws OseeCoreException {
        Class<? extends AbstractDataProxy> clazz = this.getProxyClazz(factoryAlias);
        Conditions.checkNotNull(clazz, (String)"DataProxy", (String)"Unable to find data proxy clazz [%s]", (Object[])new Object[]{factoryAlias});
        AbstractDataProxy dataProxy = null;
        try {
            dataProxy = clazz.newInstance();
            dataProxy.setLogger(this.getLogger());
            dataProxy.setStorage(this.createStorage());
        }
        catch (Exception ex) {
            this.getLogger().error((Throwable)ex, "Error creating data proxy for [%s]", new Object[]{factoryAlias});
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return dataProxy;
    }

    private Storage createStorage() {
        IResourceManager resourceManager = this.getResourceManager();
        ResourceHandler handler = new ResourceHandler(resourceManager);
        return new Storage(handler);
    }
}

