/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import java.io.Closeable;
import java.io.File;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.ds.CharacterDataProxy;
import org.eclipse.osee.orcs.db.internal.proxy.AbstractDataProxy;

public class MappedDataProxy
extends AbstractDataProxy
implements CharacterDataProxy {
    private String localUri = null;
    private String remoteUri = null;
    private File backingFile = null;

    public Object[] getData() {
        return new Object[]{"", this.remoteUri};
    }

    public String getDisplayableString() {
        return this.isFromLocalWorkspace() ? this.localUri : "Remote Content";
    }

    public void setData(Object ... objects) {
        if (objects != null && objects.length > 1) {
            this.remoteUri = (String)objects[1];
        }
    }

    public void persist(long storageId) throws OseeCoreException {
        try {
            if (this.isFromLocalWorkspace()) {
                Closeable inputStream = null;
                Lib.close(inputStream);
            }
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    public void purge() {
    }

    public void setDisplayableString(String toDisplay) {
    }

    public String getValueAsString() {
        if (this.isRemoteUriValid() && !this.isBackingFileValid()) {
            try {
                this.backingFile = this.requestRemoteFile();
                this.localUri = null;
            }
            catch (Exception ex) {
                this.getLogger().error((Throwable)ex, "Requesting remote file", new Object[0]);
            }
        }
        String toReturn = this.localUri;
        if (this.isBackingFileValid()) {
            toReturn = this.backingFile.getAbsolutePath();
        }
        return toReturn;
    }

    private boolean isBackingFileValid() {
        return this.backingFile != null && this.backingFile.exists() && this.backingFile.canRead();
    }

    public boolean setValue(Object value) {
        return false;
    }

    private File requestRemoteFile() throws Exception {
        return null;
    }

    public void setLocalUri(String localUri) {
        this.localUri = localUri;
    }

    private boolean isRemoteUriValid() {
        return Strings.isValid((String)this.remoteUri);
    }

    private boolean isFromLocalWorkspace() {
        return !this.isRemoteUriValid();
    }

    public Object getValue() {
        return this.getValueAsString();
    }
}

